/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.client;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.zeith.hammerlib.client.model.IBakedModel;
import org.zeith.hammerlib.client.model.LoadUnbakedGeometry;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.solarflux.block.SolarPanelBlock;

@LoadUnbakedGeometry(path="solar_panel")
public class SolarPanelItemModel
implements IUnbakedGeometry<SolarPanelItemModel> {
    final SolarPanelBlock block;
    Material baseTx;
    Material topTx;

    public SolarPanelItemModel(JsonObject obj, JsonDeserializationContext context) {
        this.block = (SolarPanelBlock)((Object)Cast.optionally((Object)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)obj, (String)"panel"))), SolarPanelBlock.class).orElseThrow(() -> new JsonSyntaxException("Unable to find solar panel block by id '" + GsonHelper.m_13906_((JsonObject)obj, (String)"panel") + "'")));
        ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)this.block);
        this.baseTx = new Material(InventoryMenu.f_39692_, new ResourceLocation(registryName.m_135827_(), "block/" + registryName.m_135815_() + "_base"));
        this.topTx = new Material(InventoryMenu.f_39692_, new ResourceLocation(registryName.m_135827_(), "block/" + registryName.m_135815_() + "_top"));
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new Baked(this.block, spriteGetter.apply(this.topTx), spriteGetter.apply(this.baseTx), modelLocation);
    }

    private static class Baked
    implements IBakedModel {
        public static final FaceBakery COOKER = new FaceBakery();
        public final ResourceLocation modelName;
        public final SolarPanelBlock block;
        public final TextureAtlasSprite top;
        public final TextureAtlasSprite base;
        final RandomSource rng = RandomSource.m_216327_();

        public Baked(SolarPanelBlock block, TextureAtlasSprite top, TextureAtlasSprite base, ResourceLocation modelName) {
            this.block = block;
            this.top = top;
            this.base = base;
            this.modelName = modelName;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction sideIn, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
            Direction[] sides;
            Direction[] directionArray;
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (sideIn == null) {
                directionArray = Direction.values();
            } else {
                Direction[] directionArray2 = new Direction[1];
                directionArray = directionArray2;
                directionArray2[0] = sideIn;
            }
            for (Direction side : sides = directionArray) {
                float[] fArray;
                float[] fArray2;
                if (side == null) continue;
                float h = this.block.panel.getPanelData().height * 16.0f;
                quads.add(COOKER.m_111600_(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, h, 16.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, side.m_122434_() == Direction.Axis.Y ? 0.0f : 16.0f - h, 16.0f, 16.0f}, 4)), side == Direction.UP ? this.top : this.base, side, (ModelState)BlockModelRotation.X0_Y0, null, true, this.modelName));
                Vector3f vector3f = new Vector3f(0.0f, h, 1.0f);
                Vector3f vector3f2 = new Vector3f(1.0f, h + 0.25f, 15.0f);
                if (side != Direction.UP) {
                    float[] fArray3 = new float[4];
                    fArray3[0] = 0.0f;
                    fArray3[1] = 0.0f;
                    fArray3[2] = 16.0f;
                    fArray2 = fArray3;
                    fArray3[3] = 1.0f;
                } else {
                    float[] fArray4 = new float[4];
                    fArray4[0] = 0.0f;
                    fArray4[1] = 0.0f;
                    fArray4[2] = 1.0f;
                    fArray2 = fArray4;
                    fArray4[3] = 16.0f;
                }
                quads.add(COOKER.m_111600_(vector3f, vector3f2, new BlockElementFace(null, 0, "#0", new BlockFaceUV(fArray2, 4)), this.base, side, (ModelState)BlockModelRotation.X0_Y0, null, true, this.modelName));
                Vector3f vector3f3 = new Vector3f(15.0f, h, 1.0f);
                Vector3f vector3f4 = new Vector3f(16.0f, h + 0.25f, 15.0f);
                if (side != Direction.UP) {
                    float[] fArray5 = new float[4];
                    fArray5[0] = 0.0f;
                    fArray5[1] = 0.0f;
                    fArray5[2] = 16.0f;
                    fArray = fArray5;
                    fArray5[3] = 1.0f;
                } else {
                    float[] fArray6 = new float[4];
                    fArray6[0] = 15.0f;
                    fArray6[1] = 0.0f;
                    fArray6[2] = 16.0f;
                    fArray = fArray6;
                    fArray6[3] = 16.0f;
                }
                quads.add(COOKER.m_111600_(vector3f3, vector3f4, new BlockElementFace(null, 0, "#0", new BlockFaceUV(fArray, 4)), this.base, side, (ModelState)BlockModelRotation.X0_Y0, null, true, this.modelName));
                quads.add(COOKER.m_111600_(new Vector3f(1.0f, h, 0.0f), new Vector3f(15.0f, h + 0.25f, 1.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 1.0f}, 4)), this.base, side, (ModelState)BlockModelRotation.X0_Y0, null, true, this.modelName));
                quads.add(COOKER.m_111600_(new Vector3f(1.0f, h, 15.0f), new Vector3f(15.0f, h + 0.25f, 16.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 1.0f}, 4)), this.base, side, (ModelState)BlockModelRotation.X0_Y0, null, true, this.modelName));
                quads.add(COOKER.m_111600_(new Vector3f(0.0f, h, 0.0f), new Vector3f(1.0f, h + 0.25f, 1.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 0.0f, 1.0f, 1.0f}, 4)), this.base, side, (ModelState)BlockModelRotation.X0_Y0, null, true, this.modelName));
                quads.add(COOKER.m_111600_(new Vector3f(15.0f, h, 0.0f), new Vector3f(16.0f, h + 0.25f, 1.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{15.0f, 0.0f, 16.0f, 1.0f}, 4)), this.base, side, (ModelState)BlockModelRotation.X0_Y0, null, true, this.modelName));
                quads.add(COOKER.m_111600_(new Vector3f(15.0f, h, 15.0f), new Vector3f(16.0f, h + 0.25f, 16.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{15.0f, 15.0f, 16.0f, 16.0f}, 4)), this.base, side, (ModelState)BlockModelRotation.X0_Y0, null, true, this.modelName));
                quads.add(COOKER.m_111600_(new Vector3f(0.0f, h, 15.0f), new Vector3f(1.0f, h + 0.25f, 16.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 15.0f, 1.0f, 16.0f}, 4)), this.base, side, (ModelState)BlockModelRotation.X0_Y0, null, true, this.modelName));
            }
            return quads;
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return false;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.rng.m_188503_(3) == 0 ? this.top : this.base;
        }
    }
}

