/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves.WSD;

import com.flanks255.simplygraves.PlayerPreferences;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PreferenceStorage
extends SavedData {
    private static final String NAME = "simplygraves_prefs";
    private static final HashMap<UUID, PlayerPreferences> data = new HashMap();
    private static PreferenceStorage INSTANCE = null;

    public CompoundTag m_7176_(CompoundTag pCompoundTag) {
        ListTag list = new ListTag();
        data.forEach((uuid, pref) -> list.add((Object)pref.save()));
        pCompoundTag.m_128365_("Prefs", (Tag)list);
        return pCompoundTag;
    }

    public static PreferenceStorage load(CompoundTag nbt) {
        if (nbt.m_128441_("Prefs")) {
            ListTag list = nbt.m_128437_("Prefs", 10);
            list.forEach(tag -> {
                CompoundTag prefTag = (CompoundTag)tag;
                data.put(prefTag.m_128342_("uuid"), PlayerPreferences.of(prefTag));
            });
        }
        return new PreferenceStorage();
    }

    public static PreferenceStorage get() {
        if (INSTANCE == null) {
            INSTANCE = (PreferenceStorage)ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_).m_8895_().m_164861_(PreferenceStorage::load, PreferenceStorage::new, NAME);
        }
        return INSTANCE;
    }

    public PlayerPreferences getPrefs(UUID player) {
        return data.computeIfAbsent(player, uuid -> {
            this.m_77762_();
            return new PlayerPreferences((UUID)uuid);
        });
    }
}

