/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves;

import com.flanks255.simplygraves.SGBlocks;
import com.flanks255.simplygraves.SimplyGraves;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.RegistryObject;

public class BlockReg<B extends Block, I extends Item, T extends BlockEntity>
implements Supplier<B> {
    private String name;
    private final RegistryObject<B> block;
    private final RegistryObject<I> item;
    private RegistryObject<BlockEntityType<T>> tile;

    @Override
    public B get() {
        return (B)((Block)this.block.get());
    }

    public String getName() {
        return this.name;
    }

    public BlockReg(String name, Supplier<B> blockSupplier, Function<B, I> itemSupplier) {
        this.name = name;
        this.block = SGBlocks.BLOCKS.register(name, blockSupplier);
        this.item = SimplyGraves.ITEMS.register(name, () -> (Item)itemSupplier.apply((Block)this.block.get()));
    }

    public BlockReg(String name, Supplier<B> blockSupplier, Function<B, I> itemSupplier, BlockEntityType.BlockEntitySupplier<T> tileSupplier) {
        this.name = name;
        this.block = SGBlocks.BLOCKS.register(name, blockSupplier);
        this.item = SimplyGraves.ITEMS.register(name, () -> (Item)itemSupplier.apply((Block)this.block.get()));
        this.tile = SGBlocks.BLOCK_ENTITIES.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)tileSupplier, (Block[])new Block[]{(Block)this.block.get()}).m_58966_(null));
    }

    public B getBlock() {
        return (B)((Block)this.block.get());
    }

    public I getItem() {
        return (I)((Item)this.item.get());
    }

    @Nonnull
    public BlockEntityType<T> getBlockEntityType() {
        return (BlockEntityType)Objects.requireNonNull(this.tile).get();
    }
}

