/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.network;

import com.flanks255.simplybackpacks.gui.SBContainer;
import com.flanks255.simplybackpacks.inventory.BackpackData;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.flanks255.simplybackpacks.items.Backpack;
import com.flanks255.simplybackpacks.items.BackpackItem;
import com.flanks255.simplybackpacks.util.BackpackUtils;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class OpenMessage {
    public static OpenMessage decode(FriendlyByteBuf buffer) {
        buffer.readByte();
        return new OpenMessage();
    }

    public static void encode(OpenMessage message, FriendlyByteBuf buffer) {
        buffer.writeByte(0);
    }

    public static void handle(OpenMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack backpack = BackpackUtils.findBackpackForHotkeys((Player)player, false);
            if (backpack.m_41784_().m_128441_("UUID")) {
                Optional<BackpackData> data = BackpackManager.get().getBackpack(backpack.m_41783_().m_128342_("UUID"));
                if (!backpack.m_41619_() && data.isPresent()) {
                    Backpack itemTier = BackpackItem.getTier(backpack);
                    if (data.get().getTier().ordinal() < itemTier.ordinal()) {
                        data.get().upgrade(itemTier);
                        ((NetworkEvent.Context)ctx.get()).getSender().m_213846_((Component)Component.m_237113_((String)("Backpack upgraded to " + itemTier.name)));
                    }
                    data.get().updateAccessRecords(player.m_7755_().getString(), System.currentTimeMillis());
                    NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new SBContainer(windowId, playerInventory, ((BackpackData)data.get()).getUuid(), ((BackpackData)data.get()).getTier(), ((BackpackData)data.get()).getHandler()), backpack.m_41786_()), buffer -> buffer.m_130077_(((BackpackData)data.get()).getUuid()).writeInt(itemTier.ordinal()));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

