/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.items;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.gui.FilterContainer;
import com.flanks255.simplybackpacks.gui.SBContainer;
import com.flanks255.simplybackpacks.inventory.BackpackData;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.flanks255.simplybackpacks.inventory.FilterItemHandler;
import com.flanks255.simplybackpacks.inventory.SBItemHandler;
import com.flanks255.simplybackpacks.items.Backpack;
import com.flanks255.simplybackpacks.network.ToggleMessageMessage;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class BackpackItem
extends Item {
    final String name;
    final Backpack tier;

    public BackpackItem(String name, Backpack tier) {
        super(new Item.Properties().m_41487_(1).m_41486_());
        this.name = name;
        this.tier = tier;
    }

    public static Backpack getTier(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof BackpackItem) {
            return ((BackpackItem)stack.m_41720_()).tier;
        }
        return Backpack.COMMON;
    }

    public static BackpackData getData(ItemStack stack) {
        UUID uuid;
        if (!(stack.m_41720_() instanceof BackpackItem)) {
            return null;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("UUID")) {
            uuid = UUID.randomUUID();
            tag.m_128362_("UUID", uuid);
        } else {
            uuid = tag.m_128342_("UUID");
        }
        return BackpackManager.get().getOrCreateBackpack(uuid, ((BackpackItem)stack.m_41720_()).tier);
    }

    public static boolean isBackpack(ItemStack stack) {
        return stack.m_41720_() instanceof BackpackItem;
    }

    @Nonnull
    public Rarity m_41460_(@Nonnull ItemStack stack) {
        return this.tier.rarity;
    }

    @Nonnull
    public Component m_41466_() {
        return Component.m_237115_((String)this.m_5524_()).m_130940_(this.tier == Backpack.ULTIMATE ? ChatFormatting.DARK_AQUA : ChatFormatting.RESET);
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return SimplyBackpacks.SOULBOUND_LOOKUP.contains(enchantment);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack backpack = playerIn.m_21120_(handIn);
        if (!worldIn.f_46443_ && playerIn instanceof ServerPlayer && backpack.m_41720_() instanceof BackpackItem) {
            BackpackData data = BackpackItem.getData(backpack);
            Backpack itemTier = ((BackpackItem)backpack.m_41720_()).tier;
            UUID uuid = data.getUuid();
            data.updateAccessRecords(playerIn.m_7755_().getString(), System.currentTimeMillis());
            if (data.getTier().ordinal() < itemTier.ordinal()) {
                data.upgrade(itemTier);
                playerIn.m_213846_((Component)Component.m_237113_((String)("Backpack upgraded to " + itemTier.name)));
            }
            if (playerIn.m_6144_()) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new FilterContainer(windowId, playerInventory, data.getFilter()), backpack.m_41786_()), buffer -> buffer.m_130079_(data.getFilter().serializeNBT()));
            } else {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new SBContainer(windowId, playerInventory, uuid, data.getTier(), data.getHandler()), backpack.m_41786_()), buffer -> buffer.m_130077_(uuid).writeInt(data.getTier().ordinal()));
            }
        }
        return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new BackpackCaps(stack);
    }

    public static void togglePickup(Player playerEntity, ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        boolean Pickup = !nbt.m_128471_("Pickup");
        nbt.m_128379_("Pickup", Pickup);
        if (playerEntity instanceof ServerPlayer) {
            SimplyBackpacks.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)playerEntity), (Object)new ToggleMessageMessage(Pickup));
        } else {
            playerEntity.m_5661_((Component)Component.m_237115_((String)(Pickup ? "simplybackpacks.autopickupenabled" : "simplybackpacks.autopickupdisabled")), true);
        }
    }

    public static boolean applyFilter(ItemStack item, ItemStack packItem) {
        LazyOptional handlerOptional = packItem.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (handlerOptional.isPresent() && handlerOptional.resolve().get() instanceof SBItemHandler) {
            BackpackData data = BackpackItem.getData(packItem);
            if (data == null) {
                return false;
            }
            FilterItemHandler filterHandler = data.getFilter();
            int filterOpts = packItem.m_41784_().m_128451_("Filter-OPT");
            boolean whitelist = (filterOpts & 1) > 0;
            boolean nbtMatch = (filterOpts & 2) > 0;
            for (int i = 0; i < 16; ++i) {
                ItemStack fStack = filterHandler.getStackInSlot(i);
                if (fStack.m_41619_() || !ItemStack.m_41656_((ItemStack)fStack, (ItemStack)item)) continue;
                if (nbtMatch) {
                    return ItemStack.m_150942_((ItemStack)fStack, (ItemStack)item) == whitelist;
                }
                return whitelist;
            }
            return !whitelist;
        }
        return false;
    }

    public static boolean pickupEvent(EntityItemPickupEvent event, ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return false;
        }
        if (!nbt.m_128471_("Pickup")) {
            return false;
        }
        LazyOptional optional = stack.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (optional.isPresent()) {
            IItemHandler handler = (IItemHandler)optional.resolve().get();
            if (!(handler instanceof SBItemHandler)) {
                return false;
            }
            if (!BackpackItem.applyFilter(event.getItem().m_32055_(), stack)) {
                return false;
            }
            ItemStack pickedUp = event.getItem().m_32055_();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack slot = handler.getStackInSlot(i);
                if (!slot.m_41619_() && (!ItemHandlerHelper.canItemStacksStack((ItemStack)slot, (ItemStack)pickedUp) || slot.m_41613_() >= slot.m_41741_() || slot.m_41613_() >= handler.getSlotLimit(i))) continue;
                int remainder = handler.insertItem(i, pickedUp.m_41777_(), false).m_41613_();
                pickedUp.m_41764_(remainder);
                if (remainder == 0) break;
            }
            return pickedUp.m_41619_();
        }
        return false;
    }

    private boolean hasTranslation(String key) {
        return !I18n.m_118938_((String)key, (Object[])new Object[0]).equals(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        String translationKey = this.m_5524_();
        if (!stack.m_41782_() || stack.m_41782_() && !stack.m_41783_().m_128441_("UUID")) {
            tooltip.add((Component)Component.m_237115_((String)"simplybackpacks.notsetup").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.GOLD));
        }
        if (stack.m_41782_()) {
            boolean pickupEnabled = stack.m_41783_().m_128471_("Pickup");
            if (pickupEnabled) {
                tooltip.add((Component)Component.m_237115_((String)"simplybackpacks.autopickupenabled"));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"simplybackpacks.autopickupdisabled"));
            }
        }
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)(translationKey + ".info")));
            if (this.hasTranslation(translationKey + ".info2")) {
                tooltip.add((Component)Component.m_237115_((String)(translationKey + ".info2")));
            }
            if (this.hasTranslation(translationKey + ".info3")) {
                tooltip.add((Component)Component.m_237115_((String)(translationKey + ".info3")));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"simplybackpacks.shift"));
        }
        if (flagIn.m_7050_() && stack.m_41783_() != null && stack.m_41783_().m_128441_("UUID")) {
            UUID uuid = stack.m_41783_().m_128342_("UUID");
            tooltip.add((Component)Component.m_237113_((String)("ID: " + uuid.toString().substring(0, 8))).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    static class BackpackCaps
    implements ICapabilityProvider {
        private final ItemStack stack;
        private LazyOptional<IItemHandler> optional = LazyOptional.empty();

        public BackpackCaps(ItemStack stack) {
            this.stack = stack;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                if (!this.optional.isPresent()) {
                    this.optional = BackpackManager.get().getCapability(this.stack);
                }
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }
    }
}

