/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.commands;

import com.flanks255.simplybackpacks.inventory.BackpackData;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class List {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires(cs -> cs.m_6761_(1))).executes(List::list)).then(Commands.m_82127_((String)"firstOpenedBy").then(Commands.m_82129_((String)"PlayerName", (ArgumentType)StringArgumentType.string()).suggests((cs, builder) -> SharedSuggestionProvider.m_82970_(List.getPlayerSuggestions((CommandContext<CommandSourceStack>)cs), (SuggestionsBuilder)builder)).executes(cs -> List.first((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"PlayerName")))))).then(Commands.m_82127_((String)"lastOpenedBy").then(Commands.m_82129_((String)"PlayerName", (ArgumentType)StringArgumentType.string()).suggests((cs, builder) -> SharedSuggestionProvider.m_82970_(List.getPlayerSuggestions((CommandContext<CommandSourceStack>)cs), (SuggestionsBuilder)builder)).executes(cs -> List.last((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"PlayerName")))));
    }

    public static Set<String> getPlayerSuggestions(CommandContext<CommandSourceStack> commandSource) {
        HashSet<String> list = new HashSet<String>();
        ((CommandSourceStack)commandSource.getSource()).m_81377_().m_6846_().m_11314_().forEach(serverPlayerEntity -> list.add(serverPlayerEntity.m_7755_().getString()));
        return list;
    }

    public static void sendBackpack(Player player, BackpackData backpack) {
        player.m_213846_((Component)Component.m_237113_((String)"===========================").m_130940_(ChatFormatting.DARK_GRAY));
        player.m_213846_((Component)Component.m_237113_((String)(backpack.getUuid().toString().substring(0, 8) + "...\nFirst: " + backpack.meta.getFirstAccessedPlayer() + "\n" + SDF.format(new Date(backpack.meta.getFirstAccessedTime())) + "\nLast: " + backpack.meta.getLastAccessedPlayer() + "\n" + SDF.format(new Date(backpack.meta.getLastAccessedTime())))));
        MutableComponent open_link = Component.m_237113_((String)"Open");
        open_link.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/sb open " + backpack.getUuid().toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Open Backpack"))).m_131140_(ChatFormatting.BLUE).m_131162_(Boolean.valueOf(true)));
        MutableComponent recover_link = Component.m_237113_((String)"Recover");
        recover_link.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/sb recover " + backpack.getUuid().toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Recover Backpack"))).m_131140_(ChatFormatting.GREEN).m_131162_(Boolean.valueOf(true)));
        MutableComponent delete_link = Component.m_237113_((String)"Delete");
        delete_link.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/sb delete " + backpack.getUuid().toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Delete Backpack"))).m_131140_(ChatFormatting.RED).m_131162_(Boolean.valueOf(true)));
        player.m_213846_((Component)Component.m_237113_((String)"[").m_7220_((Component)open_link).m_130946_("] - [").m_7220_((Component)recover_link).m_130946_("] - [").m_7220_((Component)delete_link).m_130946_("]"));
    }

    public static int list(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BackpackManager backpacks = BackpackManager.get();
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        if (backpacks.getMap().size() == 0) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"[ ]"), false);
            return 0;
        }
        backpacks.getMap().forEach((uuid, backpack) -> List.sendBackpack((Player)player, backpack));
        return 0;
    }

    public static int first(CommandContext<CommandSourceStack> ctx, String playerName) throws CommandSyntaxException {
        BackpackManager backpacks = BackpackManager.get();
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        if (backpacks.getMap().size() == 0) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"[ ]"), false);
            return 0;
        }
        backpacks.getMap().forEach((uuid, backpack) -> {
            if (backpack.meta.getFirstAccessedPlayer().equalsIgnoreCase(playerName)) {
                List.sendBackpack((Player)player, backpack);
            }
        });
        return 0;
    }

    public static int last(CommandContext<CommandSourceStack> ctx, String playerName) throws CommandSyntaxException {
        BackpackManager backpacks = BackpackManager.get();
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        if (backpacks.getMap().size() == 0) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"[ ]"), false);
            return 0;
        }
        backpacks.getMap().forEach((uuid, backpack) -> {
            if (backpack.meta.getLastAccessedPlayer().equalsIgnoreCase(playerName)) {
                List.sendBackpack((Player)player, backpack);
            }
        });
        return 0;
    }
}

