/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.commands;

import com.flanks255.simplybackpacks.inventory.BackpackData;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.flanks255.simplybackpacks.util.BackpackUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class Delete {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"delete").requires(cs -> cs.m_6761_(1))).then(Commands.m_82129_((String)"UUID", (ArgumentType)StringArgumentType.string()).executes(cs -> Delete.delete((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"UUID"))))).then(Commands.m_82129_((String)"CONFIRMATION", (ArgumentType)StringArgumentType.string()).executes(cs -> Delete.delete((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"CONFIRMATION"))));
    }

    public static int delete(CommandContext<CommandSourceStack> ctx, String stringUUID) throws CommandSyntaxException {
        UUID uuid;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        BackpackManager backpacks = BackpackManager.get();
        if (stringUUID.length() == 8) {
            BackpackUtils.getConfirmation(stringUUID).ifPresent(confirmation -> {
                if (player.m_20148_().equals(confirmation.player())) {
                    backpacks.removeBackpack(confirmation.backpack());
                    BackpackUtils.removeConfirmation(stringUUID);
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplybackpacks.delete.finished", (Object[])new Object[]{confirmation.backpack()}), false);
                }
            });
        }
        try {
            uuid = UUID.fromString(stringUUID);
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
        Optional<BackpackData> data = backpacks.getBackpack(uuid);
        data.ifPresentOrElse(backpack -> {
            String code = BackpackUtils.generateCode(player.m_9236_().f_46441_);
            BackpackUtils.addConfirmation(code, player.m_20148_(), backpack.getUuid());
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplybackpacks.delete.confirmation", (Object[])new Object[]{Component.m_237113_((String)code).m_130940_(ChatFormatting.GOLD)}), false);
        }, () -> ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"simplybackpacks.invaliduuid")));
        return 0;
    }
}

