/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.simplemagnets.gui.DemagnetizationCoilContainer;
import com.supermartijn642.simplemagnets.gui.FilteredDemagnetizationCoilContainer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DemagnetizationCoilBlock
extends BaseBlock
implements EntityHoldingBlock {
    private static final BlockShape[] SHAPES;
    public static final EnumProperty<Direction> FACING;
    private final Supplier<Integer> maxRange;
    private final Supplier<Boolean> hasFilter;
    private final Supplier<BaseBlockEntityType<?>> blockEntityType;

    public DemagnetizationCoilBlock(Supplier<Integer> maxRange, Supplier<Boolean> hasFilter, Supplier<BaseBlockEntityType<?>> blockEntityType) {
        super(false, BlockProperties.create().mapColor(MapColor.f_283818_).sound(SoundType.f_56743_).requiresCorrectTool().destroyTime(3.0f).explosionResistance(5.0f).sound(SoundType.f_56743_));
        this.maxRange = maxRange;
        this.hasFilter = hasFilter;
        this.blockEntityType = blockEntityType;
        this.m_49959_((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)Direction.DOWN));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        if (!level.f_46443_) {
            CommonUtils.openContainer((BaseContainer)(this.hasFilter.get() != false ? new FilteredDemagnetizationCoilContainer(player, pos) : new DemagnetizationCoilContainer(player, pos)));
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        if (this.hasFilter.get().booleanValue()) {
            info.accept((Component)TextComponents.translation((String)"simplemagnets.demagnetization_coil.info.filtered", (Object[])new Object[]{TextComponents.number((int)this.maxRange.get()).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.GRAY).get());
        } else {
            info.accept((Component)TextComponents.translation((String)"simplemagnets.demagnetization_coil.info.no_filter", (Object[])new Object[]{TextComponents.number((int)this.maxRange.get()).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.GRAY).get());
        }
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return this.blockEntityType.get().m_155264_(pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_43719_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.m_61143_(FACING)).m_122411_()].getUnderlying();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    static {
        BlockShape shape = BlockShape.or((BlockShape)BlockShape.createBlockShape((double)7.0, (double)10.5, (double)7.0, (double)9.0, (double)11.0, (double)9.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)1.0, (double)11.5), BlockShape.createBlockShape((double)6.5, (double)2.0, (double)6.5, (double)9.5, (double)10.5, (double)9.5), BlockShape.createBlockShape((double)5.5, (double)1.0, (double)5.5, (double)10.5, (double)1.5, (double)10.5), BlockShape.createBlockShape((double)6.0, (double)1.5, (double)6.0, (double)10.0, (double)2.0, (double)10.0), BlockShape.createBlockShape((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0), BlockShape.createBlockShape((double)5.5, (double)8.0, (double)5.5, (double)10.5, (double)9.0, (double)10.5), BlockShape.createBlockShape((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), BlockShape.createBlockShape((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), BlockShape.createBlockShape((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), BlockShape.createBlockShape((double)5.5, (double)4.0, (double)5.5, (double)10.5, (double)5.0, (double)10.5), BlockShape.createBlockShape((double)5.5, (double)6.0, (double)5.5, (double)10.5, (double)7.0, (double)10.5)});
        SHAPES = new BlockShape[Direction.values().length];
        DemagnetizationCoilBlock.SHAPES[Direction.DOWN.m_122411_()] = shape;
        DemagnetizationCoilBlock.SHAPES[Direction.UP.m_122411_()] = shape.rotate(Direction.Axis.X).rotate(Direction.Axis.X);
        DemagnetizationCoilBlock.SHAPES[Direction.NORTH.m_122411_()] = shape.rotate(Direction.Axis.X).rotate(Direction.Axis.X).rotate(Direction.Axis.X);
        DemagnetizationCoilBlock.SHAPES[Direction.EAST.m_122411_()] = shape.rotate(Direction.Axis.Z).rotate(Direction.Axis.Z).rotate(Direction.Axis.Z);
        DemagnetizationCoilBlock.SHAPES[Direction.SOUTH.m_122411_()] = shape.rotate(Direction.Axis.X);
        DemagnetizationCoilBlock.SHAPES[Direction.WEST.m_122411_()] = shape.rotate(Direction.Axis.Z);
        FACING = BlockStateProperties.f_61372_;
    }
}

