/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.signbutton.button;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.gigaherz.signbutton.button.SignButtonBlock;
import dev.gigaherz.signbutton.button.SignButtonBlockEntity;
import dev.gigaherz.signbutton.button.SignButtonWoodTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SignButtonRenderer
implements BlockEntityRenderer<SignButtonBlockEntity> {
    public static final Material SIGN_BUTTON_OVERLAY_MATERIAL = new Material(Sheets.f_110739_, new ResourceLocation("signbutton", "entity/sign_button"));
    private final Map<WoodType, SignRenderer.SignModel> signModels;
    private final Map<WoodType, SignModel> overlayModels;
    private final Map<WoodType, Material> signMaterials = new HashMap<WoodType, Material>();
    private final Font font;

    public static ModelLayerLocation createSignButtonModelName(WoodType p_171292_) {
        ResourceLocation location = new ResourceLocation(p_171292_.f_61839_());
        return new ModelLayerLocation(new ResourceLocation(location.m_135827_(), "sign/" + location.m_135815_()), "signbutton_overlay");
    }

    private static Material createSignMaterial(WoodType p_173386_) {
        ResourceLocation location = new ResourceLocation(p_173386_.f_61839_());
        return new Material(Sheets.f_110739_, new ResourceLocation(location.m_135827_(), "entity/signs/" + location.m_135815_()));
    }

    public SignButtonRenderer(BlockEntityRendererProvider.Context ctx) {
        this.signModels = (Map)SignButtonWoodTypes.supported().collect(ImmutableMap.toImmutableMap(Function.identity(), woodType -> new SignRenderer.SignModel(ctx.m_173582_(ModelLayers.m_171291_((WoodType)woodType)))));
        this.overlayModels = (Map)SignButtonWoodTypes.supported().collect(ImmutableMap.toImmutableMap(Function.identity(), woodType -> new SignModel(ctx.m_173582_(SignButtonRenderer.createSignButtonModelName(woodType)))));
        this.font = ctx.m_173586_();
    }

    public void render(SignButtonBlockEntity signButtonBlockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int glowCombinedLight;
        boolean drawOutline;
        int color1;
        float scale = 0.6666667f;
        poseStack.m_85836_();
        BlockState blockstate = signButtonBlockEntity.m_58900_();
        boolean powered = (Boolean)blockstate.m_61143_((Property)SignButtonBlock.POWERED);
        Direction facing = (Direction)blockstate.m_61143_(SignButtonBlock.FACING);
        AttachFace face = (AttachFace)blockstate.m_61143_(SignButtonBlock.FACE);
        int rotAroundX = 0;
        switch (face) {
            case CEILING: {
                rotAroundX = 90;
                break;
            }
            case FLOOR: {
                rotAroundX = -90;
            }
        }
        int rotAroundY = 0;
        switch (facing) {
            case SOUTH: {
                break;
            }
            case NORTH: {
                rotAroundY = 180;
                break;
            }
            case EAST: {
                rotAroundY = 90;
                break;
            }
            case WEST: {
                rotAroundY = -90;
            }
        }
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)rotAroundY));
        poseStack.m_252781_(Axis.f_252529_.m_252977_((float)rotAroundX));
        poseStack.m_85837_(0.0, -0.3125, -0.4375 - (powered ? 0.035 : 0.0));
        WoodType woodtype = signButtonBlockEntity.getWoodType();
        SignRenderer.SignModel model = this.signModels.get(woodtype);
        SignModel overlayModel = this.overlayModels.get(woodtype);
        model.f_112507_.f_104207_ = false;
        poseStack.m_85836_();
        poseStack.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
        Material material = this.signMaterials.computeIfAbsent(woodtype, woodType -> SignButtonRenderer.createSignMaterial(woodtype));
        VertexConsumer ivertexbuilder = material.m_119194_(bufferIn, ButtonRenderTypes::entityTranslucentUnsorted);
        model.f_173655_.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        VertexConsumer ivertexbuilder2 = SIGN_BUTTON_OVERLAY_MATERIAL.m_119194_(bufferIn, ButtonRenderTypes::entityTranslucentUnsorted);
        overlayModel.root.m_104301_(poseStack, ivertexbuilder2, combinedLightIn, combinedOverlayIn);
        poseStack.m_85849_();
        poseStack.m_85837_(0.0, 0.3333333432674408, 0.046666666865348816);
        poseStack.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
        SignText frontText = signButtonBlockEntity.m_277142_();
        int adjustedColor = SignRenderer.m_173639_((SignText)frontText);
        FormattedCharSequence[] lines = frontText.m_277130_(Minecraft.m_91087_().m_167974_(), text -> {
            List list = this.font.m_92923_((FormattedText)text, 90);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        if (frontText.m_276843_()) {
            color1 = frontText.m_276773_().m_41071_();
            drawOutline = SignRenderer.m_277119_((BlockPos)signButtonBlockEntity.m_58899_(), (int)color1);
            glowCombinedLight = 0xF000F0;
        } else {
            color1 = adjustedColor;
            drawOutline = false;
            glowCombinedLight = combinedLightIn;
        }
        for (int line = 0; line < 4; ++line) {
            FormattedCharSequence text2 = lines[line];
            if (text2 == null) continue;
            float f3 = -this.font.m_92724_(text2) / 2;
            if (drawOutline) {
                this.font.m_168645_(text2, f3, (float)(line * 10 - 20), color1, adjustedColor, poseStack.m_85850_().m_252922_(), bufferIn, glowCombinedLight);
                continue;
            }
            this.font.m_272191_(text2, f3, (float)(line * 10 - 20), color1, false, poseStack.m_85850_().m_252922_(), bufferIn, Font.DisplayMode.NORMAL, 0, glowCombinedLight);
        }
        poseStack.m_85849_();
    }

    public static final class SignModel
    extends Model {
        public final ModelPart root;

        public SignModel(ModelPart p_173657_) {
            super(RenderType::m_110458_);
            this.root = p_173657_;
        }

        public void m_7695_(PoseStack p_112510_, VertexConsumer p_112511_, int p_112512_, int p_112513_, float p_112514_, float p_112515_, float p_112516_, float p_112517_) {
            this.root.m_104306_(p_112510_, p_112511_, p_112512_, p_112513_, p_112514_, p_112515_, p_112516_, p_112517_);
        }
    }

    private static class ButtonRenderTypes
    extends RenderType {
        private ButtonRenderTypes(String name, VertexFormat fmt, VertexFormat.Mode glMode, int bufferSize, boolean useDelegate, boolean useSorting, Runnable setupRendering, Runnable cleanupRendering) {
            super(name, fmt, glMode, bufferSize, useDelegate, useSorting, setupRendering, cleanupRendering);
        }

        public static RenderType entityTranslucentUnsorted(ResourceLocation texture, boolean doOverlay) {
            RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110139_).m_110663_(f_110113_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(doOverlay);
            return ButtonRenderTypes.m_173215_((String)"entity_translucent_unsorted", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState);
        }

        public static RenderType entityTranslucentUnsorted(ResourceLocation texture) {
            return ButtonRenderTypes.entityTranslucentUnsorted(texture, true);
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="signbutton", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Events {
        public static LayerDefinition createSignOverlayLayer() {
            CubeDeformation def = new CubeDeformation(0.01f);
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            partdefinition.m_171599_("sign", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-12.0f, -14.0f, -1.0f, 24.0f, 12.0f, 2.0f, def), PartPose.f_171404_);
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
        }

        @SubscribeEvent
        public static void layers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            SignButtonWoodTypes.supported().forEach(woodType -> event.registerLayerDefinition(SignButtonRenderer.createSignButtonModelName(woodType), Events::createSignOverlayLayer));
        }
    }
}

