/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.signbutton.button;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.gigaherz.signbutton.button.SignButtonBlockEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SignButtonBlock
extends SignBlock
implements EntityBlock {
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final int TICK_RATE = 30;
    private final Map<BlockState, VoxelShape> cache = Maps.newConcurrentMap();

    public SignButtonBlock(BlockBehaviour.Properties properties, WoodType woodType) {
        super(properties, woodType);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(FACE, (Comparable)AttachFace.FLOOR)).m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_56268_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACE, FACING, POWERED, f_56268_});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SignButtonBlockEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        VoxelShape cached = this.cache.get(state);
        if (cached == null) {
            cached = Shapes.m_83040_();
            AttachFace face = (AttachFace)state.m_61143_(FACE);
            Direction enumfacing = (Direction)state.m_61143_(FACING);
            boolean powered = (Boolean)state.m_61143_((Property)POWERED);
            float u0 = 0.0f;
            float u1 = 1.0f;
            float offset = 0.02f;
            float v0 = 0.25f;
            float v1 = 0.75f;
            float thick = 0.085f;
            float w0 = (powered ? -0.23f : 0.32f) / 16.0f;
            float w1 = w0 + thick;
            float t1 = 1.0f - w0;
            float t0 = 1.0f - w1;
            if (face == AttachFace.FLOOR) {
                switch (enumfacing) {
                    case NORTH: {
                        cached = Shapes.m_83048_((double)u0, (double)w0, (double)(v0 + offset), (double)u1, (double)w1, (double)(v1 + offset));
                        break;
                    }
                    case SOUTH: {
                        cached = Shapes.m_83048_((double)u0, (double)w0, (double)(v0 - offset), (double)u1, (double)w1, (double)(v1 - offset));
                        break;
                    }
                    case EAST: {
                        cached = Shapes.m_83048_((double)(v0 - offset), (double)w0, (double)u0, (double)(v1 - offset), (double)w1, (double)u1);
                        break;
                    }
                    case WEST: {
                        cached = Shapes.m_83048_((double)(v0 + offset), (double)w0, (double)u0, (double)(v1 + offset), (double)w1, (double)u1);
                    }
                }
            } else if (face == AttachFace.CEILING) {
                switch (enumfacing) {
                    case NORTH: {
                        cached = Shapes.m_83048_((double)u0, (double)t0, (double)(v0 - offset), (double)u1, (double)t1, (double)(v1 - offset));
                        break;
                    }
                    case SOUTH: {
                        cached = Shapes.m_83048_((double)u0, (double)t0, (double)(v0 + offset), (double)u1, (double)t1, (double)(v1 + offset));
                        break;
                    }
                    case EAST: {
                        cached = Shapes.m_83048_((double)(v0 + offset), (double)t0, (double)u0, (double)(v1 + offset), (double)t1, (double)u1);
                        break;
                    }
                    case WEST: {
                        cached = Shapes.m_83048_((double)(v0 - offset), (double)t0, (double)u0, (double)(v1 - offset), (double)t1, (double)u1);
                    }
                }
            } else {
                switch (enumfacing) {
                    case EAST: {
                        cached = Shapes.m_83048_((double)w0, (double)(v0 + offset), (double)u0, (double)w1, (double)(v1 + offset), (double)u1);
                        break;
                    }
                    case WEST: {
                        cached = Shapes.m_83048_((double)t0, (double)(v0 + offset), (double)u0, (double)t1, (double)(v1 + offset), (double)u1);
                        break;
                    }
                    case SOUTH: {
                        cached = Shapes.m_83048_((double)u0, (double)(v0 + offset), (double)w0, (double)u1, (double)(v1 + offset), (double)w1);
                        break;
                    }
                    case NORTH: {
                        cached = Shapes.m_83048_((double)u0, (double)(v0 + offset), (double)t0, (double)u1, (double)(v1 + offset), (double)t1);
                    }
                }
            }
            this.cache.put(state, cached);
        }
        return cached;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction clickedFace = context.m_43719_().m_122424_();
        ArrayList directions = Lists.newArrayList((Object[])new Direction[]{clickedFace});
        Arrays.stream(context.m_6232_()).filter(f -> f != clickedFace).forEach(directions::add);
        for (int i = 0; i < directions.size(); ++i) {
            Direction facing;
            AttachFace face;
            Direction lookDirection2;
            Direction lookDirection = (Direction)directions.get(i);
            Direction direction = lookDirection2 = i + 1 >= directions.size() ? Direction.NORTH : (Direction)directions.get(i + 1);
            if (lookDirection == Direction.DOWN) {
                face = AttachFace.FLOOR;
                facing = (lookDirection2.m_122434_() == Direction.Axis.Y ? Direction.NORTH : lookDirection2).m_122424_();
            } else if (lookDirection == Direction.UP) {
                face = AttachFace.CEILING;
                facing = (lookDirection2.m_122434_() == Direction.Axis.Y ? Direction.NORTH : lookDirection2).m_122424_();
            } else {
                face = AttachFace.WALL;
                facing = lookDirection.m_122424_();
            }
            state = (BlockState)((BlockState)state.m_61124_(FACE, (Comparable)face)).m_61124_(FACING, (Comparable)facing);
            if (!state.m_60710_((LevelReader)world, pos)) continue;
            return (BlockState)state.m_61124_((Property)f_56268_, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    @Deprecated
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_121945_(this.getEffectiveFacing(state).m_122424_())).m_280296_();
    }

    private Direction getEffectiveFacing(BlockState state) {
        switch ((AttachFace)state.m_61143_(FACE)) {
            case FLOOR: {
                return Direction.UP;
            }
            case CEILING: {
                return Direction.DOWN;
            }
        }
        return (Direction)state.m_61143_(FACING);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        switch ((AttachFace)state.m_61143_(FACE)) {
            case WALL: {
                if (hit.m_82434_() == state.m_61143_(FACING)) break;
                return super.m_6227_(state, worldIn, pos, player, handIn, hit);
            }
            case FLOOR: {
                if (hit.m_82434_() == Direction.UP) break;
                return super.m_6227_(state, worldIn, pos, player, handIn, hit);
            }
            case CEILING: {
                if (hit.m_82434_() == Direction.DOWN) break;
                return super.m_6227_(state, worldIn, pos, player, handIn, hit);
            }
        }
        if (!((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)));
            worldIn.m_5594_(player, pos, SoundEvents.f_12632_, SoundSource.BLOCKS, 0.3f, 0.6f);
            this.notifyFacing(state, worldIn, pos);
            worldIn.m_186460_(new BlockPos((Vec3i)pos), (Block)this, 30);
        }
        return InteractionResult.SUCCESS;
    }

    public float m_276903_(BlockState state) {
        return ((Direction)state.m_61143_(FACING)).m_122435_();
    }

    private void notifyFacing(BlockState state, Level worldIn, BlockPos pos) {
        this.notifyNeighbors(worldIn, pos, this.getEffectiveFacing(state).m_122424_());
    }

    private void notifyNeighbors(Level worldIn, BlockPos pos, Direction facing) {
        worldIn.m_46672_(pos, (Block)this);
        worldIn.m_46672_(pos.m_121945_(facing), (Block)this);
    }

    @Deprecated
    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    @Deprecated
    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)POWERED) != false && this.getEffectiveFacing(blockState) == side ? 15 : 0;
    }

    @Deprecated
    public boolean m_7899_(BlockState state) {
        return true;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.m_122424_() == this.getEffectiveFacing(stateIn) && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Deprecated
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.m_60734_() != newState.m_60734_()) {
            if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
                this.notifyFacing(state, worldIn, pos);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    @Deprecated
    public void m_213898_(BlockState p_222954_, ServerLevel p_222955_, BlockPos p_222956_, RandomSource p_222957_) {
        super.m_213898_(p_222954_, p_222955_, p_222956_, p_222957_);
    }

    @Deprecated
    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.f_46443_ && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            this.notifyFacing(state, (Level)worldIn, pos);
            worldIn.m_5594_(null, pos, SoundEvents.f_12631_, SoundSource.BLOCKS, 0.3f, 0.5f);
        }
    }

    @Deprecated
    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.f_46443_ && !((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            this.checkArrows(state, worldIn, pos);
        }
    }

    private void checkArrows(BlockState state, Level worldIn, BlockPos pos) {
        boolean currentlyPowered;
        List list = worldIn.m_45976_(AbstractArrow.class, state.m_60808_((BlockGetter)worldIn, pos).m_83215_().m_82338_(pos));
        boolean arrowsPresent = !list.isEmpty();
        if (arrowsPresent != (currentlyPowered = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue())) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)));
            this.notifyFacing(state, worldIn, pos);
            worldIn.m_5594_(null, pos, SoundEvents.f_12632_, SoundSource.BLOCKS, 0.3f, 0.6f);
        }
        if (arrowsPresent) {
            worldIn.m_186460_(new BlockPos((Vec3i)pos), (Block)this, 30);
        }
    }
}

