/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.renderer;

import com.misterpemodder.shulkerboxtooltip.impl.renderer.BasePreviewRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientBundleTooltip;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VanillaPreviewRenderer
extends BasePreviewRenderer {
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("textures/gui/container/bundle.png");
    public static final VanillaPreviewRenderer INSTANCE = new VanillaPreviewRenderer();

    VanillaPreviewRenderer() {
        super(18, 20, 2, 2);
    }

    @Override
    public int getWidth() {
        return this.getMaxRowSize() * 18 + 2;
    }

    @Override
    public int getHeight() {
        return this.getRowCount() * 20 + 3;
    }

    private int getColumnCount() {
        return Math.min(this.getMaxRowSize(), this.getInvSize());
    }

    private int getRowCount() {
        return (int)Math.ceil((double)this.getInvSize() / (double)this.getMaxRowSize());
    }

    @Override
    public void draw(int x, int y, GuiGraphics context, Font textRenderer, int mouseX, int mouseY) {
        this.setTexture();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        this.drawBackground(x, ++y, this.getColumnCount(), this.getRowCount(), context);
        this.drawItems(x, y, context, textRenderer);
        this.drawInnerTooltip(x, y, context, textRenderer, mouseX, mouseY);
    }

    private void drawBackground(int x, int y, int columns, int rows, GuiGraphics context) {
        int row;
        ResourceLocation texture = this.getTexture();
        for (row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                this.drawSprite(context, 1 + x + 18 * col, 1 + y + 20 * row, texture, ClientBundleTooltip.Texture.SLOT);
            }
        }
        this.drawSprite(context, x, y, texture, ClientBundleTooltip.Texture.BORDER_CORNER_TOP);
        this.drawSprite(context, x + columns * 18 + 1, y, texture, ClientBundleTooltip.Texture.BORDER_CORNER_TOP);
        for (int col = 0; col < columns; ++col) {
            this.drawSprite(context, x + 1 + col * 18, y, texture, ClientBundleTooltip.Texture.BORDER_HORIZONTAL_TOP);
            this.drawSprite(context, x + 1 + col * 18, y + rows * 20, texture, ClientBundleTooltip.Texture.BORDER_HORIZONTAL_BOTTOM);
        }
        for (row = 0; row < rows; ++row) {
            this.drawSprite(context, x, y + row * 20 + 1, texture, ClientBundleTooltip.Texture.BORDER_VERTICAL);
            this.drawSprite(context, x + columns * 18 + 1, y + row * 20 + 1, texture, ClientBundleTooltip.Texture.BORDER_VERTICAL);
        }
        this.drawSprite(context, x, y + rows * 20, texture, ClientBundleTooltip.Texture.BORDER_CORNER_BOTTOM);
        this.drawSprite(context, x + columns * 18 + 1, y + rows * 20, texture, ClientBundleTooltip.Texture.BORDER_CORNER_BOTTOM);
    }

    private void setTexture() {
        if (this.textureOverride == null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)DEFAULT_TEXTURE);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.textureOverride);
        }
    }

    private ResourceLocation getTexture() {
        if (this.textureOverride == null) {
            return DEFAULT_TEXTURE;
        }
        return this.textureOverride;
    }

    private void drawSprite(GuiGraphics context, int x, int y, ResourceLocation texture, ClientBundleTooltip.Texture sprite) {
        context.m_280398_(texture, x, y, 0, (float)sprite.f_169919_, (float)sprite.f_169920_, sprite.f_169921_, sprite.f_169922_, 128, 128);
    }
}

