/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.PluginManager;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.network.EnderChestInventoryListener;
import com.misterpemodder.shulkerboxtooltip.impl.network.ProtocolVersion;
import com.misterpemodder.shulkerboxtooltip.impl.network.RegistrationChangeType;
import com.misterpemodder.shulkerboxtooltip.impl.network.forge.ServerNetworkingImpl;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CEnderChestUpdate;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CMessages;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ServerNetworking {
    private static final Map<ServerPlayer, ProtocolVersion> CLIENTS = new WeakHashMap<ServerPlayer, ProtocolVersion>();

    public static boolean hasModAvailable(ServerPlayer player) {
        return CLIENTS.containsKey(player);
    }

    public static void addClient(ServerPlayer client, ProtocolVersion version) {
        CLIENTS.put(client, version);
        PluginManager.loadProviders();
        Configuration.EnderChestSyncType ecSyncType = ShulkerBoxTooltip.config.server.enderChestSyncType;
        if (ecSyncType != Configuration.EnderChestSyncType.NONE) {
            S2CMessages.ENDER_CHEST_UPDATE.sendTo(client, S2CEnderChestUpdate.create(client.m_36327_()));
        }
        if (ecSyncType == Configuration.EnderChestSyncType.ACTIVE) {
            EnderChestInventoryListener.attachTo(client);
        }
    }

    public static void removeClient(ServerPlayer client) {
        CLIENTS.remove(client);
        EnderChestInventoryListener.detachFrom(client);
    }

    public static Packet<?> createS2CPacket(ResourceLocation channelId, FriendlyByteBuf buf) {
        return new ClientboundCustomPayloadPacket(channelId, buf);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        ServerNetworkingImpl.init();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerC2SReceiver(ResourceLocation channelId, ServerPlayer player, PacketReceiver receiver) {
        void var2_2;
        void var1_1;
        ServerNetworkingImpl.registerC2SReceiver(channelId, (ServerPlayer)var1_1, (PacketReceiver)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void unregisterC2SReceiver(ResourceLocation channelId, ServerPlayer player) {
        void var1_1;
        ServerNetworkingImpl.unregisterC2SReceiver(channelId, (ServerPlayer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addRegistrationChangeListener(ResourceLocation channelId, RegistrationChangeListener listener) {
        void var1_1;
        ServerNetworkingImpl.addRegistrationChangeListener(channelId, (RegistrationChangeListener)var1_1);
    }

    @FunctionalInterface
    public static interface RegistrationChangeListener {
        public void onRegistrationChange(ServerPlayer var1, RegistrationChangeType var2);
    }

    @FunctionalInterface
    public static interface PacketReceiver {
        public void handle(ServerPlayer var1, FriendlyByteBuf var2);
    }
}

