/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api.color;

import com.misterpemodder.shulkerboxtooltip.impl.color.ColorKeyImpl;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import java.util.Arrays;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.NonExtendable
public interface ColorKey {
    public static final ColorKey DEFAULT = ColorKey.ofRgb(0xFFFFFF);
    public static final ColorKey ENDER_CHEST = ColorKey.ofRgb(740161);
    public static final ColorKey SHULKER_BOX = ColorKey.ofRgb(0x976797);
    public static final ColorKey WHITE_SHULKER_BOX = ColorKey.ofDye(DyeColor.WHITE);
    public static final ColorKey ORANGE_SHULKER_BOX = ColorKey.ofDye(DyeColor.ORANGE);
    public static final ColorKey MAGENTA_SHULKER_BOX = ColorKey.ofDye(DyeColor.MAGENTA);
    public static final ColorKey LIGHT_BLUE_SHULKER_BOX = ColorKey.ofDye(DyeColor.LIGHT_BLUE);
    public static final ColorKey YELLOW_SHULKER_BOX = ColorKey.ofDye(DyeColor.YELLOW);
    public static final ColorKey LIME_SHULKER_BOX = ColorKey.ofDye(DyeColor.LIME);
    public static final ColorKey PINK_SHULKER_BOX = ColorKey.ofDye(DyeColor.PINK);
    public static final ColorKey GRAY_SHULKER_BOX = ColorKey.ofDye(DyeColor.GRAY);
    public static final ColorKey LIGHT_GRAY_SHULKER_BOX = ColorKey.ofDye(DyeColor.LIGHT_GRAY);
    public static final ColorKey CYAN_SHULKER_BOX = ColorKey.ofDye(DyeColor.CYAN);
    public static final ColorKey PURPLE_SHULKER_BOX = ColorKey.ofDye(DyeColor.PURPLE);
    public static final ColorKey BLUE_SHULKER_BOX = ColorKey.ofDye(DyeColor.BLUE);
    public static final ColorKey BROWN_SHULKER_BOX = ColorKey.ofDye(DyeColor.BROWN);
    public static final ColorKey GREEN_SHULKER_BOX = ColorKey.ofDye(DyeColor.GREEN);
    public static final ColorKey RED_SHULKER_BOX = ColorKey.ofDye(DyeColor.RED);
    public static final ColorKey BLACK_SHULKER_BOX = ColorKey.ofDye(DyeColor.BLACK);

    public int rgb();

    public float[] rgbComponents();

    public int defaultRgb();

    public float[] defaultRgbComponents();

    public void setRgb(int var1);

    public void setRgb(float[] var1);

    public static ColorKey copyOf(ColorKey original) {
        return ColorKey.ofRgb(original.rgbComponents());
    }

    public static ColorKey ofRgb(float[] rgb) {
        return new ColorKeyImpl(new float[]{rgb[0], rgb[1], rgb[2]}, new float[]{rgb[0], rgb[1], rgb[2]});
    }

    public static ColorKey ofRgb(int rgb) {
        float[] components = ShulkerBoxTooltipUtil.rgbToComponents(rgb);
        return new ColorKeyImpl(components, new float[]{components[0], components[1], components[2]});
    }

    private static ColorKey ofDye(DyeColor dye) {
        float[] components = dye.m_41068_();
        components[0] = Math.max(0.15f, components[0]);
        components[1] = Math.max(0.15f, components[1]);
        components[2] = Math.max(0.15f, components[2]);
        return new ColorKeyImpl(Arrays.copyOf(components, 3), new float[]{components[0], components[1], components[2]});
    }
}

