/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.crafting;

import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.mixins.SPC_ShapedRecipe_Invoker;

public abstract class AbstractShapedRecipe
extends ShapedRecipe {
    public AbstractShapedRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(id, group, category, width, height, ingredients, result);
    }

    public abstract RecipeSerializer<?> m_7707_();

    public static abstract class Serializer<T extends AbstractShapedRecipe>
    implements RecipeSerializer<T> {
        public final T fromJson(ResourceLocation id, JsonObject json) {
            try {
                String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
                Map<String, Ingredient> map = SPC_ShapedRecipe_Invoker.invokeReadSymbols(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
                String[] pattern = SPC_ShapedRecipe_Invoker.invokeRemovePadding(SPC_ShapedRecipe_Invoker.invokeGetPattern(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
                int width = pattern[0].length();
                int height = pattern.length;
                NonNullList<Ingredient> ingredients = SPC_ShapedRecipe_Invoker.invokeCreatePatternMatrix(pattern, map, width, height);
                ItemStack result = AbstractShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
                return this.fromJson(id, json, group, width, height, ingredients, result);
            }
            catch (AssertionError ignored) {
                ShetiPhianCore.LOGGER.error("ShapedRecipe Mixin Failed To Load; Recipe " + id + " will not function");
                return null;
            }
        }

        protected abstract T fromJson(ResourceLocation var1, JsonObject var2, String var3, int var4, int var5, NonNullList<Ingredient> var6, ItemStack var7);

        public final T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            String group = buffer.m_130277_();
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int index = 0; index < ingredients.size(); ++index) {
                ingredients.set(index, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            return this.fromNetwork(id, buffer, group, width, height, (NonNullList<Ingredient>)ingredients, result);
        }

        protected abstract T fromNetwork(ResourceLocation var1, FriendlyByteBuf var2, String var3, int var4, int var5, NonNullList<Ingredient> var6, ItemStack var7);

        public void toNetwork(FriendlyByteBuf buffer, AbstractShapedRecipe recipe) {
            buffer.m_130130_(recipe.m_44220_());
            buffer.m_130130_(recipe.m_44221_());
            buffer.m_130070_(recipe.m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
        }
    }
}

