/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.table.SewingTableMenu;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="sewingkit", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SewingTableScreen
extends AbstractContainerScreen<SewingTableMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = SewingKitMod.location("textures/gui/sewing_station.png");
    private static SewingRecipe recipeContext;
    private float sliderProgress;
    private boolean clickedOnScroll;
    private int recipeIndexOffset;
    private boolean hasItemsInInputSlot;

    @SubscribeEvent
    public static void gatherComponents(RenderTooltipEvent.GatherComponents event) {
        if (recipeContext != null) {
            event.getTooltipElements().add(Either.right((Object)new RecipeTooltipComponent(recipeContext)));
        }
    }

    public SewingTableScreen(SewingTableMenu containerIn, Inventory playerInv, Component titleIn) {
        super((AbstractContainerMenu)containerIn, playerInv, titleIn);
        containerIn.setInventoryUpdateListener(this::onInventoryUpdate);
        --this.f_97729_;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.drawRecipeCosts(graphics, mouseX, mouseY);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        this.m_280273_(graphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.f_97735_;
        int j = this.f_97736_;
        graphics.m_280218_(BACKGROUND_TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(41.0f * this.sliderProgress);
        graphics.m_280218_(BACKGROUND_TEXTURE, i + 119, j + 15 + k, 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int l = this.f_97735_ + 52;
        int i1 = this.f_97736_ + 14;
        int j1 = this.recipeIndexOffset + 12;
        this.renderButtons(graphics, x, y, l, i1, j1);
        this.drawRecipesItems(graphics, l, i1, j1);
    }

    protected void m_280072_(GuiGraphics graphics, int x, int y) {
        super.m_280072_(graphics, x, y);
        if (this.hasItemsInInputSlot) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.recipeIndexOffset + 12;
            List<SewingRecipe> list = ((SewingTableMenu)this.f_97732_).getRecipeList();
            for (int l = this.recipeIndexOffset; l < k && l < ((SewingTableMenu)this.f_97732_).getRecipeListSize(); ++l) {
                int i1 = l - this.recipeIndexOffset;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                recipeContext = ((SewingTableMenu)this.f_97732_).getRecipeList().get(l);
                graphics.m_280153_(this.f_96547_, list.get(l).getResultItem(), x, y);
                recipeContext = null;
            }
        }
    }

    private void drawRecipeCosts(GuiGraphics graphics, int mouseX, int mouseY) {
        int recipeIdx = ((SewingTableMenu)this.f_97732_).getSelectedRecipe();
        if (recipeIdx < 0 || recipeIdx >= ((SewingTableMenu)this.f_97732_).getRecipeListSize()) {
            return;
        }
        SewingRecipe recipe = ((SewingTableMenu)this.f_97732_).getRecipeList().get(recipeIdx);
        if (recipe == null) {
            return;
        }
        Map<Ingredient, Integer> remaining = recipe.getMaterials().stream().collect(Collectors.toMap(i -> i.ingredient, i -> i.count));
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 300.0f);
        for (int i2 = 0; i2 < 4; ++i2) {
            Slot slot = (Slot)((SewingTableMenu)this.f_97732_).f_38839_.get(i2 + 2);
            int subtract = 0;
            for (Map.Entry<Ingredient, Integer> mat : remaining.entrySet()) {
                Ingredient ing = mat.getKey();
                int value = mat.getValue();
                ItemStack stack1 = slot.m_7993_();
                if (!ing.test(stack1)) continue;
                int remaining1 = Math.max(0, value - (stack1.m_41613_() + subtract));
                subtract += value - remaining1;
                mat.setValue(remaining1);
            }
            if (subtract == true || slot.m_7993_().m_41613_() <= 0) continue;
            int x = slot.f_40220_ + this.f_97735_;
            int y = slot.f_40221_ + this.f_97736_;
            String text = String.format("%s", subtract);
            int w = this.f_96547_.m_92895_(text);
            graphics.m_280488_(this.f_96547_, text, x + 17 - w, y, 0xFFFF55);
        }
        poseStack.m_85849_();
    }

    private void renderButtons(GuiGraphics graphics, int x, int y, int p_238853_4_, int p_238853_5_, int p_238853_6_) {
        for (int i = this.recipeIndexOffset; i < p_238853_6_ && i < ((SewingTableMenu)this.f_97732_).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = p_238853_4_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_238853_5_ + l * 18 + 2;
            int j1 = this.f_97727_;
            if (i == ((SewingTableMenu)this.f_97732_).getSelectedRecipe()) {
                j1 += 18;
            } else if (x >= k && y >= i1 && x < k + 16 && y < i1 + 18) {
                j1 += 36;
            }
            graphics.m_280218_(BACKGROUND_TEXTURE, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void drawRecipesItems(GuiGraphics graphics, int left, int top, int recipeIndexOffsetMax) {
        PoseStack poseStack = new PoseStack();
        List<SewingRecipe> list = ((SewingTableMenu)this.f_97732_).getRecipeList();
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((SewingTableMenu)this.f_97732_).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            poseStack.m_252880_(0.0f, 0.0f, 0.0f);
            graphics.m_280480_(list.get(i).getResultItem(), k, i1);
            graphics.m_280370_(this.f_96547_, list.get(i).getResultItem(), k, i1);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.clickedOnScroll = false;
        if (this.hasItemsInInputSlot) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < k; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((SewingTableMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((SewingTableMenu)this.f_97732_).f_38840_, l);
                return true;
            }
            i = this.f_97735_ + 119;
            j = this.f_97736_ + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.clickedOnScroll = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedOnScroll && this.canScroll()) {
            int i = this.f_97736_ + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - delta / (double)i);
            this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && ((SewingTableMenu)this.f_97732_).getRecipeListSize() > 12;
    }

    protected int getHiddenRows() {
        return (((SewingTableMenu)this.f_97732_).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((SewingTableMenu)this.f_97732_).isAbleToCraft();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }

    public record RecipeTooltipComponent(SewingRecipe recipe) implements TooltipComponent
    {
    }

    public static class ClientRecipeTooltipComponent
    implements ClientTooltipComponent {
        private static final ResourceLocation RECIPE_TEXTURE = SewingKitMod.location("textures/gui/recipetooltip.png");
        private final SewingRecipe recipe;
        private final Component label;

        public ClientRecipeTooltipComponent(RecipeTooltipComponent component) {
            this.recipe = component.recipe();
            this.label = Component.m_237115_((String)"text.sewingkit.recipe");
        }

        public int m_142103_() {
            return 38;
        }

        public int m_142069_(Font font) {
            return Math.max(76, font.m_92852_((FormattedText)this.label));
        }

        public void m_183452_(Font font, int x, int y, GuiGraphics graphics) {
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 150.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Objects.requireNonNull(font);
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 150.0f);
            graphics.m_280430_(font, this.label, x, y += 9, 0xFFFFFF);
            poseStack.m_85849_();
            Objects.requireNonNull(font);
            y += 9;
            NonNullList<SewingRecipe.Material> materials = this.recipe.getMaterials();
            for (int i = 0; i < materials.size(); ++i) {
                int xx = x + i * 17 + 4;
                SewingRecipe.Material material = (SewingRecipe.Material)materials.get(i);
                ItemStack[] stacks = material.ingredient.m_43908_();
                if (stacks.length > 0) {
                    long ticks = Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_.m_46467_() : 0L;
                    ItemStack stack = stacks[(int)(ticks / 32L % (long)stacks.length)].m_41777_();
                    stack.m_41764_(1);
                    poseStack.m_85836_();
                    poseStack.m_252880_(0.0f, 0.0f, -50.0f);
                    graphics.m_280480_(stack, xx, y);
                    graphics.m_280370_(font, stack, xx, y);
                    poseStack.m_85849_();
                } else {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    graphics.m_280163_(RECIPE_TEXTURE, xx, y, 36.0f, 0.0f, 16, 16, 64, 64);
                }
                if (material.count == 1) continue;
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 0.0f, 150.0f);
                String text = String.format("%d", material.count);
                int w = font.m_92895_(text);
                graphics.m_280488_(font, text, xx + 17 - w, y + 9, 0xFFFFFF);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="sewingkit", bus=Mod.EventBusSubscriber.Bus.MOD)
    public class ModBusEvent {
        @SubscribeEvent
        public static void register(RegisterClientTooltipComponentFactoriesEvent event) {
            event.register(RecipeTooltipComponent.class, ClientRecipeTooltipComponent::new);
        }
    }
}

