/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.sewingkit.SewingKitDataGen;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.api.ToolActionIngredient;
import dev.gigaherz.sewingkit.clothing.ClothArmorItem;
import dev.gigaherz.sewingkit.clothing.ClothArmorMaterial;
import dev.gigaherz.sewingkit.file.FileItem;
import dev.gigaherz.sewingkit.loot.RandomDye;
import dev.gigaherz.sewingkit.needle.NeedleItem;
import dev.gigaherz.sewingkit.needle.Needles;
import dev.gigaherz.sewingkit.patterns.PatternItem;
import dev.gigaherz.sewingkit.structure.TailorShopProcessor;
import dev.gigaherz.sewingkit.table.SewingTableBlock;
import dev.gigaherz.sewingkit.table.SewingTableMenu;
import dev.gigaherz.sewingkit.table.SewingTableScreen;
import dev.gigaherz.sewingkit.table.StoringSewingTableBlock;
import dev.gigaherz.sewingkit.table.StoringSewingTableBlockEntity;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="sewingkit")
public class SewingKitMod {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "sewingkit";
    public static CreativeModeTab SEWING_KIT;
    public static final TagKey<Block> BONE_TAG;
    public static final Tier BONE_TIER;
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<Block> BLOCKS;
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    private static final DeferredRegister<PoiType> POI_TYPES;
    private static final DeferredRegister<VillagerProfession> PROFESSIONS;
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS;
    private static final DeferredRegister<MenuType<?>> MENU_TYPES;
    private static final DeferredRegister<StructureProcessorType<?>> STRUCTURE_PROCESSORS;
    private static final DeferredRegister<LootItemFunctionType> LOOT_FUNCTIONS;
    private static final DeferredRegister<CreativeModeTab> CREATIVE_TABS;
    public static final RegistryObject<Item> LEATHER_STRIP;
    public static final RegistryObject<Item> LEATHER_SHEET;
    public static final RegistryObject<Item> WOOL_ROLL;
    public static final RegistryObject<Item> WOOL_TRIM;
    public static final RegistryObject<Item> WOOD_SEWING_NEEDLE;
    public static final RegistryObject<Item> STONE_SEWING_NEEDLE;
    public static final RegistryObject<Item> BONE_SEWING_NEEDLE;
    public static final RegistryObject<Item> GOLD_SEWING_NEEDLE;
    public static final RegistryObject<Item> IRON_SEWING_NEEDLE;
    public static final RegistryObject<Item> DIAMOND_SEWING_NEEDLE;
    public static final RegistryObject<Item> NETHERITE_SEWING_NEEDLE;
    public static final RegistryObject<Block> SEWING_STATION_BLOCK;
    public static final RegistryObject<Item> SEWING_STATION_ITEM;
    public static final RegistryObject<Block> STORING_SEWING_STATION_BLOCK;
    public static final RegistryObject<Item> STORING_SEWING_STATION_ITEM;
    public static final RegistryObject<BlockEntityType<?>> STORING_SEWING_STATION_BLOCK_ENTITY;
    public static final RegistryObject<Item> WOOL_HAT;
    public static final RegistryObject<Item> WOOL_SHIRT;
    public static final RegistryObject<Item> WOOL_PANTS;
    public static final RegistryObject<Item> WOOL_SHOES;
    public static final RegistryObject<Item> COMMON_PATTERN;
    public static final RegistryObject<Item> UNCOMMON_PATTERN;
    public static final RegistryObject<Item> RARE_PATTERN;
    public static final RegistryObject<Item> LEGENDARY_PATTERN;
    public static final RegistryObject<Item> FILE;
    public static final RegistryObject<PoiType> TABLE_POI;
    public static final RegistryObject<VillagerProfession> TAILOR;
    public static final RegistryObject<RecipeType<SewingRecipe>> SEWING;
    public static final RegistryObject<RecipeSerializer<SewingRecipe>> SEWING_RECIPE;
    public static final RegistryObject<MenuType<SewingTableMenu>> SEWING_STATION_MENU;
    public static final RegistryObject<LootItemFunctionType> RANDOM_DYE;
    public static final RegistryObject<StructureProcessorType<TailorShopProcessor>> TAILOR_SHOP_PROCESSOR;
    private static final ResourceKey<StructureProcessorList> TAILOR_SHOP_PROCESSOR_LIST_KEY;
    public static final RegistryObject<CreativeModeTab> SEWING_KIT_TAB;

    public SewingKitMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::construct);
        modBus.addListener(this::gatherData);
        ITEMS.register(modBus);
        BLOCKS.register(modBus);
        POI_TYPES.register(modBus);
        PROFESSIONS.register(modBus);
        BLOCK_ENTITIES.register(modBus);
        RECIPE_SERIALIZERS.register(modBus);
        MENU_TYPES.register(modBus);
        RECIPE_TYPES.register(modBus);
        LOOT_FUNCTIONS.register(modBus);
        STRUCTURE_PROCESSORS.register(modBus);
        CREATIVE_TABS.register(modBus);
        MinecraftForge.EVENT_BUS.addListener(this::villagerTrades);
        MinecraftForge.EVENT_BUS.addListener(this::addBuildingToVillages);
    }

    private void construct(FMLConstructModEvent event) {
        event.enqueueWork(() -> CraftingHelper.register((ResourceLocation)ToolActionIngredient.NAME, ToolActionIngredient.Serializer.INSTANCE));
    }

    public void addBuildingToVillages(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_256948_).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_257011_).orElseThrow();
        SewingKitMod.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/plains/houses"), "sewingkit:tailor_shop", 5);
        SewingKitMod.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/snowy/houses"), "sewingkit:tailor_shop", 5);
        SewingKitMod.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/savanna/houses"), "sewingkit:tailor_shop", 5);
        SewingKitMod.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/taiga/houses"), "sewingkit:tailor_shop", 5);
        SewingKitMod.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/desert/houses"), "sewingkit:tailor_shop", 5);
    }

    private static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        Holder.Reference emptyProcessorList = processorListRegistry.m_246971_(TAILOR_SHOP_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210531_((String)nbtPieceRL, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
    }

    private void villagerTrades(VillagerTradesEvent event) {
        if (event.getType() != TAILOR.get()) {
            return;
        }
        Int2ObjectMap trademap = event.getTrades();
        ((List)trademap.get(1)).addAll(Arrays.asList(new VillagerTrades.DyedArmorForEmeralds((Item)WOOL_PANTS.get(), 3, 12, 1), new VillagerTrades.DyedArmorForEmeralds((Item)WOOL_SHOES.get(), 3, 12, 1), new VillagerTrades.DyedArmorForEmeralds((Item)WOOL_HAT.get(), 3, 12, 1), new VillagerTrades.DyedArmorForEmeralds((Item)WOOL_SHIRT.get(), 3, 12, 1), this.buyItem(new ItemStack((ItemLike)Items.f_42401_, 16), 1, 12, 1, 2.0f)));
        ((List)trademap.get(2)).addAll(Arrays.asList(new SellRandomFromTag((TagKey<Item>)ItemTags.f_215867_, 8, 7, 8, 1, 2.0f), this.sellItem((ItemLike)COMMON_PATTERN.get(), 15, 1, 10, 4.0f), this.buyItem(new ItemStack((ItemLike)LEATHER_STRIP.get(), 2), 1, 12, 1, 0.5f), this.buyItem(new ItemStack((ItemLike)Items.f_42401_, 16), 1, 12, 1, 2.0f)));
        ((List)trademap.get(3)).addAll(Arrays.asList(this.sellItem((ItemLike)UNCOMMON_PATTERN.get(), 15, 1, 10, 4.0f)));
        ((List)trademap.get(4)).addAll(Arrays.asList(this.sellItem((ItemLike)RARE_PATTERN.get(), 15, 1, 10, 4.0f)));
        ((List)trademap.get(5)).addAll(Arrays.asList(this.sellItem((ItemLike)LEGENDARY_PATTERN.get(), 15, 1, 10, 4.0f)));
    }

    private VillagerTrades.ItemListing sellItem(ItemLike thing, int price, int maxTrades, int xp, float priceMultiplier) {
        return this.sellItem(new ItemStack(thing), price, maxTrades, xp, priceMultiplier);
    }

    private VillagerTrades.ItemListing sellItem(ItemStack thing, int price, int maxTrades, int xp, float priceMultiplier) {
        return new BasicItemListing(new ItemStack((ItemLike)Items.f_42616_, price), thing, maxTrades, xp, priceMultiplier);
    }

    private VillagerTrades.ItemListing buyItem(ItemStack thing, int reward, int maxTrades, int xp, float priceMultiplier) {
        return new BasicItemListing(thing, new ItemStack((ItemLike)Items.f_42616_, reward), maxTrades, xp, priceMultiplier);
    }

    private void gatherData(GatherDataEvent event) {
        SewingKitDataGen.gatherData(event);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    static {
        BONE_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("sewingkit:needs_bone_tool"));
        BONE_TIER = TierSortingRegistry.registerTier((Tier)new ForgeTier(Tiers.STONE.m_6604_(), 100, 1.0f, 0.0f, 0, BONE_TAG, () -> Ingredient.m_204132_((TagKey)Tags.Items.BONES)), (ResourceLocation)new ResourceLocation("sewingkit:bone"), List.of(Tiers.WOOD), List.of(Tiers.IRON));
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MODID);
        BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)MODID);
        POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)MODID);
        PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)MODID);
        RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)MODID);
        RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)MODID);
        MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)MODID);
        STRUCTURE_PROCESSORS = DeferredRegister.create((ResourceKey)Registries.f_256983_, (String)MODID);
        LOOT_FUNCTIONS = DeferredRegister.create((ResourceKey)Registries.f_257015_, (String)MODID);
        CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)MODID);
        LEATHER_STRIP = ITEMS.register("leather_strip", () -> new Item(new Item.Properties().m_41487_(64)));
        LEATHER_SHEET = ITEMS.register("leather_sheet", () -> new Item(new Item.Properties().m_41487_(64)));
        WOOL_ROLL = ITEMS.register("wool_roll", () -> new Item(new Item.Properties().m_41487_(64)));
        WOOL_TRIM = ITEMS.register("wool_trim", () -> new Item(new Item.Properties().m_41487_(64)));
        WOOD_SEWING_NEEDLE = ITEMS.register("wood_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.WOOD, new Item.Properties()));
        STONE_SEWING_NEEDLE = ITEMS.register("stone_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.STONE, new Item.Properties()));
        BONE_SEWING_NEEDLE = ITEMS.register("bone_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.BONE, new Item.Properties()));
        GOLD_SEWING_NEEDLE = ITEMS.register("gold_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.GOLD, new Item.Properties()));
        IRON_SEWING_NEEDLE = ITEMS.register("iron_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.IRON, new Item.Properties()));
        DIAMOND_SEWING_NEEDLE = ITEMS.register("diamond_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.DIAMOND, new Item.Properties()));
        NETHERITE_SEWING_NEEDLE = ITEMS.register("netherite_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.NETHERITE, new Item.Properties()));
        SEWING_STATION_BLOCK = BLOCKS.register("sewing_station", () -> new SewingTableBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(2.5f)));
        SEWING_STATION_ITEM = ITEMS.register("sewing_station", () -> new BlockItem((Block)SEWING_STATION_BLOCK.get(), new Item.Properties()));
        STORING_SEWING_STATION_BLOCK = BLOCKS.register("storing_sewing_station", () -> new StoringSewingTableBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(2.5f)));
        STORING_SEWING_STATION_ITEM = ITEMS.register("storing_sewing_station", () -> new BlockItem((Block)STORING_SEWING_STATION_BLOCK.get(), new Item.Properties()));
        STORING_SEWING_STATION_BLOCK_ENTITY = BLOCK_ENTITIES.register("storing_sewing_station", () -> BlockEntityType.Builder.m_155273_(StoringSewingTableBlockEntity::new, (Block[])new Block[]{(Block)STORING_SEWING_STATION_BLOCK.get()}).m_58966_(null));
        WOOL_HAT = ITEMS.register("wool_hat", () -> new ClothArmorItem(ClothArmorMaterial.WOOL, ArmorItem.Type.HELMET, new Item.Properties()));
        WOOL_SHIRT = ITEMS.register("wool_shirt", () -> new ClothArmorItem(ClothArmorMaterial.WOOL, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
        WOOL_PANTS = ITEMS.register("wool_pants", () -> new ClothArmorItem(ClothArmorMaterial.WOOL, ArmorItem.Type.LEGGINGS, new Item.Properties()));
        WOOL_SHOES = ITEMS.register("wool_shoes", () -> new ClothArmorItem(ClothArmorMaterial.WOOL, ArmorItem.Type.BOOTS, new Item.Properties()));
        COMMON_PATTERN = ITEMS.register("common_pattern", () -> new PatternItem(new Item.Properties().m_41497_(Rarity.COMMON)));
        UNCOMMON_PATTERN = ITEMS.register("uncommon_pattern", () -> new PatternItem(new Item.Properties().m_41497_(Rarity.UNCOMMON)));
        RARE_PATTERN = ITEMS.register("rare_pattern", () -> new PatternItem(new Item.Properties().m_41497_(Rarity.RARE)));
        LEGENDARY_PATTERN = ITEMS.register("legendary_pattern", () -> new PatternItem(new Item.Properties().m_41497_(Rarity.EPIC)));
        FILE = ITEMS.register("file", () -> new FileItem(new Item.Properties().m_41503_(354)));
        TABLE_POI = POI_TYPES.register("tailor", () -> new PoiType(Stream.concat(((Block)SEWING_STATION_BLOCK.get()).m_49965_().m_61056_().stream(), ((Block)STORING_SEWING_STATION_BLOCK.get()).m_49965_().m_61056_().stream()).collect(Collectors.toUnmodifiableSet()), 1, 1));
        TAILOR = PROFESSIONS.register("tailor", () -> {
            ResourceKey key = Objects.requireNonNull(TABLE_POI.getKey());
            return new VillagerProfession("tailor", holder -> holder.m_203565_(key), holder -> holder.m_203565_(key), (ImmutableSet)Arrays.stream(Needles.values()).map(Needles::getNeedle).collect(ImmutableSet.toImmutableSet()), ImmutableSet.of(), null);
        });
        SEWING = RECIPE_TYPES.register("sewing", () -> new RecipeType<SewingRecipe>(){

            public String toString() {
                return "sewingkit:sewing";
            }
        });
        SEWING_RECIPE = RECIPE_SERIALIZERS.register("sewing", () -> new SewingRecipe.Serializer());
        SEWING_STATION_MENU = MENU_TYPES.register("sewing_station", () -> new MenuType(SewingTableMenu::new, FeatureFlags.f_244332_));
        RANDOM_DYE = LOOT_FUNCTIONS.register("random_dye", () -> new LootItemFunctionType((Serializer)new RandomDye.Serializer()));
        TAILOR_SHOP_PROCESSOR = STRUCTURE_PROCESSORS.register("tailor_shop_processor", () -> TailorShopProcessor::codec);
        TAILOR_SHOP_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)SewingKitMod.location("tailor_shop_processors"));
        SEWING_KIT_TAB = CREATIVE_TABS.register("sewing_kit", () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0).m_257737_(() -> new ItemStack((ItemLike)WOOD_SEWING_NEEDLE.get())).m_257941_((Component)Component.m_237115_((String)"tab.sewing_kit")).m_257501_((featureFlags, output) -> {
            output.m_246326_((ItemLike)SEWING_STATION_ITEM.get());
            output.m_246326_((ItemLike)STORING_SEWING_STATION_ITEM.get());
            output.m_246326_((ItemLike)WOOD_SEWING_NEEDLE.get());
            output.m_246326_((ItemLike)STONE_SEWING_NEEDLE.get());
            output.m_246326_((ItemLike)BONE_SEWING_NEEDLE.get());
            output.m_246326_((ItemLike)GOLD_SEWING_NEEDLE.get());
            output.m_246326_((ItemLike)IRON_SEWING_NEEDLE.get());
            output.m_246326_((ItemLike)DIAMOND_SEWING_NEEDLE.get());
            output.m_246326_((ItemLike)NETHERITE_SEWING_NEEDLE.get());
            output.m_246326_((ItemLike)FILE.get());
            output.m_246326_((ItemLike)LEATHER_STRIP.get());
            output.m_246326_((ItemLike)LEATHER_SHEET.get());
            output.m_246326_((ItemLike)WOOL_ROLL.get());
            output.m_246326_((ItemLike)WOOL_TRIM.get());
            output.m_246326_((ItemLike)WOOL_HAT.get());
            output.m_246326_((ItemLike)WOOL_SHIRT.get());
            output.m_246326_((ItemLike)WOOL_PANTS.get());
            output.m_246326_((ItemLike)WOOL_SHOES.get());
            output.m_246326_((ItemLike)COMMON_PATTERN.get());
            output.m_246326_((ItemLike)UNCOMMON_PATTERN.get());
            output.m_246326_((ItemLike)RARE_PATTERN.get());
            output.m_246326_((ItemLike)LEGENDARY_PATTERN.get());
        }).m_257652_());
    }

    private static class SellRandomFromTag
    implements VillagerTrades.ItemListing {
        private final TagKey<Item> tagSource;
        private final int quantity;
        private final int price;
        private final int maxUses;
        private final int xp;
        private final float priceMultiplier;

        private SellRandomFromTag(TagKey<Item> tagSource, int quantity, int price, int maxUses, int xp, float priceMultiplier) {
            this.tagSource = tagSource;
            this.quantity = quantity;
            this.price = price;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity p_219693_, RandomSource rand) {
            return Optional.ofNullable(ForgeRegistries.ITEMS.tags()).map(tags -> tags.getTag(this.tagSource)).flatMap(tag -> tag.getRandomElement(rand)).map(itemHolder -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.price), new ItemStack((ItemLike)itemHolder, this.quantity), this.maxUses, this.xp, this.priceMultiplier)).orElse(null);
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModBus {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)SEWING_STATION_MENU.get()), SewingTableScreen::new));
        }

        @SubscribeEvent
        public static void itemColors(RegisterColorHandlersEvent.Item event) {
            event.register((stack, color) -> color > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{(ItemLike)WOOL_HAT.get(), (ItemLike)WOOL_SHIRT.get(), (ItemLike)WOOL_PANTS.get(), (ItemLike)WOOL_SHOES.get()});
        }
    }
}

