/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.lootmodifiers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import elucent.rootsclassic.config.RootsConfig;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.registry.RootsTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DropModifier {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"rootsclassic");
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> ROOTSCLASSIC_DROPS = GLM.register("rootsclassic_drops", BlockDropModifier.CODEC);

    public static class BlockDropModifier
    extends LootModifier {
        public static final Supplier<Codec<BlockDropModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> BlockDropModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, BlockDropModifier::new)));

        public BlockDropModifier(LootItemCondition[] lootConditions) {
            super(lootConditions);
        }

        @Nonnull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            if (context.m_78936_(LootContextParams.f_81461_)) {
                BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
                Block block = state.m_60734_();
                RandomSource rand = context.m_230907_();
                if (block instanceof TallGrassBlock && (Integer)RootsConfig.oldRootDropChance.get() > 0 && rand.m_188503_(((Integer)RootsConfig.oldRootDropChance.get()).intValue()) == 0) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)RootsRegistry.OLD_ROOT.get(), 1));
                }
                if ((block == Blocks.f_50092_ || block == Blocks.f_50249_ || block == Blocks.f_50250_ || block == Blocks.f_50444_) && ((CropBlock)block).m_52307_(state) && (Integer)RootsConfig.verdantSprigDropChance.get() > 0 && rand.m_188503_(((Integer)RootsConfig.verdantSprigDropChance.get()).intValue()) == 0) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1));
                }
                if (block == Blocks.f_50200_ && (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) == 3 && (Integer)RootsConfig.infernalStemDropChance.get() > 0 && rand.m_188503_(((Integer)RootsConfig.infernalStemDropChance.get()).intValue()) == 0) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)RootsRegistry.INFERNAL_BULB.get(), 1));
                }
                if (block == Blocks.f_50491_ && (Integer)RootsConfig.dragonsEyeDropChance.get() > 0 && rand.m_188503_(((Integer)RootsConfig.dragonsEyeDropChance.get()).intValue()) == 0) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)RootsRegistry.DRAGONS_EYE.get(), 1));
                }
                if (block instanceof LeavesBlock && !generatedLoot.stream().anyMatch(stack -> stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() == block) && (Integer)RootsConfig.berriesDropChance.get() > 0 && rand.m_188503_(((Integer)RootsConfig.berriesDropChance.get()).intValue()) == 0) {
                    Item berry = (Item)RootsRegistry.ELDERBERRY.get();
                    berry = ForgeRegistries.ITEMS.tags().getTag(RootsTags.BERRIES).getRandomElement(rand).orElse(berry);
                    generatedLoot.add((Object)new ItemStack((ItemLike)berry));
                }
            }
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return (Codec)ROOTSCLASSIC_DROPS.get();
        }
    }
}

