/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.compat.jei.category;

import elucent.rootsclassic.compat.jei.JEIPlugin;
import elucent.rootsclassic.recipe.ComponentRecipe;
import elucent.rootsclassic.registry.RootsRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MortarCategory
implements IRecipeCategory<ComponentRecipe> {
    private static final ResourceLocation backgroundLocation = new ResourceLocation("rootsclassic", "textures/gui/tabletmortar.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public MortarCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(backgroundLocation, 21, 30, 142, 45).addPadding(0, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RootsRegistry.MORTAR.get()));
        this.localizedName = Component.m_237115_((String)"rootsclassic.gui.jei.category.mortar");
    }

    public RecipeType<ComponentRecipe> getRecipeType() {
        return JEIPlugin.MORTAR_TYPE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ComponentRecipe recipe, IFocusGroup focuses) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.m_9598_();
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            Ingredient ingredient = (Ingredient)recipe.m_7527_().get(i);
            builder.addSlot(RecipeIngredientRole.INPUT, 3 + i * 16, 26).addIngredients(ingredient);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 123, 26).addItemStack(recipe.m_5874_((Container)new SimpleContainer(new ItemStack[0]), registryAccess));
    }

    public void draw(ComponentRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }
}

