/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTypeTools;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketVariableToServer(BlockPos pos, int varIndex, CompoundTag tagCompound) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolscontrol", "variable_to_server");

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.varIndex);
        buf.m_130079_(this.tagCompound);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketVariableToServer create(FriendlyByteBuf buf) {
        return new PacketVariableToServer(buf.m_130135_(), buf.readInt(), buf.m_130260_());
    }

    public static PacketVariableToServer create(BlockPos blockPos, int varIdx, CompoundTag tag) {
        return new PacketVariableToServer(blockPos, varIdx, tag);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(playerEntity -> {
            ProcessorTileEntity processor;
            Parameter[] variables;
            BlockEntity te = playerEntity.m_20193_().m_7702_(this.pos);
            if (te instanceof ProcessorTileEntity && this.varIndex < (variables = (processor = (ProcessorTileEntity)te).getVariableArray()).length) {
                Parameter parameter = variables[this.varIndex];
                ParameterType type = parameter.getParameterType();
                ParameterValue value = ParameterTypeTools.readFromNBT(this.tagCompound, type);
                variables[this.varIndex] = Parameter.builder().type(type).value(value).build();
                processor.m_6596_();
            }
        }));
    }
}

