/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import com.mojang.blaze3d.vertex.BufferBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.varia.TagTools;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.Tags;

public class ShapeBlockInfo {
    private static final Col COL_DEFAULT = new Col(0.5f, 0.3f, 0.5f);
    private static final Col COL_LAVA = new Col(0.83137256f, 0.3529412f, 0.07058824f);
    private static final Col COL_NETHERBRICK = new Col(0.1764706f, 0.09019608f, 0.105882354f);
    private static final Col COL_SCANNER = new Col(0.0f, 0.0f, 0.8862745f);
    private static final IBlockRender BD_RAIL = new DefaultRender(0.1f, 0.2f);
    private static final IBlockRender BD_GRASS = new DefaultRender(0.1f, 0.2f);
    private static final IBlockRender BD_TORCH = new DefaultRender(0.4f, 0.7f);
    private static final IBlockRender BD_FLOWER = new DefaultRender(0.4f, 0.6f);
    private static final IBlockRender BD_MUSHROOM = new DefaultRender(0.3f, 0.5f);
    private static final IBlockRender BD_BARS = new DefaultRender(0.4f, 1.0f);
    private static final IBlockRender BD_VINE = new DefaultRender(0.4f, 1.0f);
    private static final IBlockRender BD_WALL = new DefaultRender(0.25f, 0.9f);
    private static final IBlockRender BD_FENCE = new DefaultRender(0.3f, 0.9f);
    private static final IBlockRender BD_SLAB = new DefaultRender(0.05f, 0.5f);
    private static final IBlockRender BD_SLAB_UPPER = new UpperslabRender(0.05f, 0.5f);
    private static final IBlockRender BD_SNOWLAYER = new DefaultRender(0.0f, 0.3f);
    private static final IBlockRender BD_FIRE = new DefaultRender(0.1f, 0.3f);
    private static final IBlockRender BD_REDSTONE = new DefaultRender(0.3f, 0.1f);
    private static final IBlockRender BD_CHEST = new DefaultRender(0.05f, 0.8f);
    private static final IBlockRender BD_TRAPDOOR = new DefaultRender(0.05f, 0.1f);
    private static final IBlockRender BD_BUTTON = new DefaultRender(0.4f, 0.1f);
    private final Col col;
    private final IBlockRender render;
    private static final Set<Block> nonSolidBlocks = new HashSet<Block>();

    public static boolean isNonSolidBlock(Block b) {
        return nonSolidBlocks.contains(b);
    }

    public ShapeBlockInfo(Col col, IBlockRender render) {
        this.col = col;
        this.render = render;
    }

    private static IBlockRender getBlockRender(BlockState state) {
        if (state == null) {
            return null;
        }
        IBlockRender render = null;
        Block block = state.m_60734_();
        Collection tags = TagTools.getTags((Block)block);
        if (block == Blocks.f_50081_ || block == Blocks.f_50174_) {
            render = BD_TORCH;
        } else if (tags.contains(BlockTags.f_13031_)) {
            render = state.m_61138_((Property)SlabBlock.f_56353_) && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM ? BD_SLAB : BD_SLAB_UPPER;
        } else if (block == Blocks.f_50125_) {
            render = BD_SNOWLAYER;
        } else if (tags.contains(BlockTags.f_13032_)) {
            render = BD_WALL;
        } else if (block == Blocks.f_50183_ || block == Blocks.f_50155_) {
            render = BD_BARS;
        } else if (block == Blocks.f_50191_) {
            render = BD_VINE;
        } else if (tags.contains(BlockTags.f_13037_) || tags.contains(BlockTags.f_13063_) || block == Blocks.f_50092_ || block == Blocks.f_50249_ || block == Blocks.f_50250_ || block == Blocks.f_50444_) {
            render = BD_FLOWER;
        } else if (block == Blocks.f_50034_) {
            render = BD_GRASS;
        } else if (tags.contains(BlockTags.f_13034_)) {
            render = BD_RAIL;
        } else if (block == Blocks.f_50073_ || block == Blocks.f_50072_) {
            render = BD_MUSHROOM;
        } else if (block == Blocks.f_50083_) {
            render = BD_FIRE;
        } else if (block == Blocks.f_50088_) {
            render = BD_REDSTONE;
        } else if (tags.contains(Tags.Blocks.CHESTS)) {
            render = BD_CHEST;
        } else if (tags.contains(BlockTags.f_13036_) || tags.contains(BlockTags.f_13100_) || block == Blocks.f_50167_ || block == Blocks.f_50165_) {
            render = BD_TRAPDOOR;
        } else if (block == Blocks.f_50164_ || tags.contains(BlockTags.f_13093_) || tags.contains(BlockTags.f_13092_)) {
            render = BD_BUTTON;
        } else if (tags.contains(BlockTags.f_13039_) || tags.contains(BlockTags.f_13098_)) {
            render = BD_FENCE;
        }
        return render;
    }

    private static Col getColor(BlockState state) {
        if (state == null) {
            return COL_DEFAULT;
        }
        Block block = state.m_60734_();
        MapColor mapColor = null;
        try {
            mapColor = state.m_284242_((BlockGetter)Minecraft.m_91087_().f_91073_, new BlockPos(0, 0, 0));
        }
        catch (Exception e) {
            mapColor = MapColor.f_283913_;
        }
        Col col = block == Blocks.f_49991_ ? COL_LAVA : (block == Blocks.f_50197_ || block == Blocks.f_50198_ || block == Blocks.f_50199_ ? COL_NETHERBRICK : (block == BuilderModule.SUPPORT.get() ? COL_DEFAULT : new Col((float)(mapColor.f_283871_ >> 16 & 0xFF) / 255.0f, (float)(mapColor.f_283871_ >> 8 & 0xFF) / 255.0f, (float)(mapColor.f_283871_ & 0xFF) / 255.0f)));
        float r = col.getR();
        float g = col.getG();
        float b = col.getB();
        if (r * 1.2f > 1.0f) {
            r = 0.825f;
        }
        if (g * 1.2f > 1.0f) {
            g = 0.825f;
        }
        if (b * 1.2f > 1.0f) {
            b = 0.825f;
        }
        col = new Col(r, g, b);
        return col;
    }

    @Nonnull
    public static ShapeBlockInfo getBlockInfo(Map<BlockState, ShapeBlockInfo> palette, BlockState state) {
        ShapeBlockInfo info = palette.get(state);
        if (info != null) {
            return info;
        }
        info = new ShapeBlockInfo(ShapeBlockInfo.getColor(state), ShapeBlockInfo.getBlockRender(state));
        palette.put(state, info);
        return info;
    }

    public Col getCol() {
        return this.col;
    }

    public IBlockRender getRender() {
        return this.render;
    }

    public boolean isNonSolid() {
        return this.render != null;
    }

    static class Col {
        private final float r;
        private final float g;
        private final float b;

        public Col(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public float getR() {
            return this.r;
        }

        public float getG() {
            return this.g;
        }

        public float getB() {
            return this.b;
        }
    }

    static interface IBlockRender {
        public void render(BufferBuilder var1, int var2, float var3, float var4, float var5);
    }

    static class DefaultRender
    implements IBlockRender {
        private final float height;
        private final float offset;

        public DefaultRender(float offset, float height) {
            this.height = height;
            this.offset = offset;
        }

        @Override
        public void render(BufferBuilder buffer, int z, float r, float g, float b) {
            float a = 0.5f;
            buffer.m_5483_((double)this.offset, (double)this.height, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), (double)this.height, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), (double)this.height, (double)(this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)this.offset, (double)this.height, (double)(this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)this.offset, 0.0, (double)(this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), 0.0, (double)(this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), 0.0, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)this.offset, 0.0, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), (double)this.height, (double)(this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), 0.0, (double)(this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.offset, 0.0, (double)(this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.offset, (double)this.height, (double)(this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), 0.0, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), (double)this.height, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.offset, (double)this.height, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.offset, 0.0, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.offset, 0.0, (double)(1.0f - this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)this.offset, (double)this.height, (double)(1.0f - this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)this.offset, (double)this.height, (double)(this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)this.offset, 0.0, (double)(this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), 0.0, (double)(this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), (double)this.height, (double)(this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), (double)this.height, (double)(1.0f - this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), 0.0, (double)(1.0f - this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
        }
    }

    static class UpperslabRender
    implements IBlockRender {
        private final float height;
        private final float offset;

        public UpperslabRender(float offset, float height) {
            this.height = height;
            this.offset = offset;
        }

        @Override
        public void render(BufferBuilder buffer, int z, float r, float g, float b) {
            float a = 0.5f;
            buffer.m_5483_((double)this.offset, (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)this.offset, (double)this.height + 0.5, (double)(this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)this.offset, 0.5, (double)(this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), 0.5, (double)(this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), 0.5, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)this.offset, 0.5, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), 0.5, (double)(this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.offset, 0.5, (double)(this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.offset, (double)this.height + 0.5, (double)(this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), 0.5, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.offset, (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.offset, 0.5, (double)(1.0f - this.offset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.offset, 0.5, (double)(1.0f - this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)this.offset, (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)this.offset, (double)this.height + 0.5, (double)(this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)this.offset, 0.5, (double)(this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), 0.5, (double)(this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.offset), 0.5, (double)(1.0f - this.offset + (float)z)).m_85950_(r, g, b, a).m_5752_();
        }
    }

    static class BlockRender
    implements IBlockRender {
        private final float height;
        private final float xoffset;
        private final float zoffset;

        public BlockRender(float xoffset, float zoffset, float height) {
            this.height = 1.0f;
            this.xoffset = xoffset;
            this.zoffset = zoffset;
        }

        @Override
        public void render(BufferBuilder buffer, int z, float r, float g, float b) {
            float a = 0.5f;
            buffer.m_5483_((double)this.xoffset, (double)this.height, (double)(1.0f - this.zoffset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.xoffset), (double)this.height, (double)(1.0f - this.zoffset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.xoffset), (double)this.height, (double)(this.zoffset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)this.xoffset, (double)this.height, (double)(this.zoffset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)this.xoffset, 0.0, (double)(this.zoffset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.xoffset), 0.0, (double)(this.zoffset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.xoffset), 0.0, (double)(1.0f - this.zoffset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)this.xoffset, 0.0, (double)(1.0f - this.zoffset + (float)z)).m_85950_(r * 0.8f, g * 0.8f, b * 0.8f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.xoffset), (double)this.height, (double)(this.zoffset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.xoffset), 0.0, (double)(this.zoffset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.xoffset, 0.0, (double)(this.zoffset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.xoffset, (double)this.height, (double)(this.zoffset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.xoffset), 0.0, (double)(1.0f - this.zoffset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.xoffset), (double)this.height, (double)(1.0f - this.zoffset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.xoffset, (double)this.height, (double)(1.0f - this.zoffset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.xoffset, 0.0, (double)(1.0f - this.zoffset + (float)z)).m_85950_(r * 1.2f, g * 1.2f, b * 1.2f, a).m_5752_();
            buffer.m_5483_((double)this.xoffset, 0.0, (double)(1.0f - this.zoffset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)this.xoffset, (double)this.height, (double)(1.0f - this.zoffset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)this.xoffset, (double)this.height, (double)(this.zoffset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)this.xoffset, 0.0, (double)(this.zoffset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.xoffset), 0.0, (double)(this.zoffset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.xoffset), (double)this.height, (double)(this.zoffset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.xoffset), (double)this.height, (double)(1.0f - this.zoffset + (float)z)).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(1.0f - this.xoffset), 0.0, (double)(1.0f - this.zoffset + (float)z)).m_85950_(r, g, b, a).m_5752_();
        }
    }
}

