/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.rftoolsbuilder.modules.scanner.ScannerConfiguration;
import mcjty.rftoolsbuilder.shapes.ShapeBlockInfo;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class RenderData {
    public static BufferBuilder vboBuffer = new BufferBuilder(0x200000);
    private RenderPlane[] planes = null;
    public String previewMessage = "";
    private long touchTime = 0L;
    private long checksum = -1L;
    private boolean wantData = true;

    public boolean hasData() {
        if (this.planes == null) {
            return false;
        }
        for (RenderPlane plane : this.planes) {
            if (plane == null || plane.vbo == null) continue;
            return true;
        }
        return false;
    }

    public int getBlockCount() {
        if (this.planes != null) {
            int cnt = 0;
            for (RenderPlane plane : this.planes) {
                if (plane == null) continue;
                cnt += plane.getCount();
            }
            return cnt;
        }
        return 0;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    public boolean isWantData() {
        return this.planes == null || this.wantData;
    }

    public void setWantData(boolean wantData) {
        this.wantData = wantData;
    }

    public RenderPlane[] getPlanes() {
        return this.planes;
    }

    public void setPlaneData(@Nullable RenderPlane plane, int offsetY, int dy) {
        if (this.planes == null) {
            this.planes = new RenderPlane[dy];
        } else if (this.planes.length != dy) {
            this.cleanup();
            this.planes = new RenderPlane[dy];
        }
        if (plane != null) {
            if (this.planes[offsetY] == null) {
                this.planes[offsetY] = plane;
            } else {
                this.planes[offsetY].refreshData(plane);
            }
        }
    }

    public void touch() {
        this.touchTime = System.currentTimeMillis();
    }

    public boolean tooOld() {
        return this.touchTime + (long)((Integer)ScannerConfiguration.clientRenderDataTimeout.get()).intValue() < System.currentTimeMillis();
    }

    public void cleanup() {
        if (this.planes != null) {
            for (RenderPlane plane : this.planes) {
                if (plane == null) continue;
                plane.cleanup();
            }
        }
    }

    public void createRenderList(int y) {
        if (this.planes != null) {
            this.planes[y].createRenderList();
        }
    }

    public void performRenderToList(int y) {
        if (this.planes != null) {
            this.planes[y].performRenderToList();
        }
    }

    public static class RenderPlane
    extends RenderElement {
        private RenderStrip[] strips;
        private int y;
        private int offsety;
        private int startz;
        private boolean dirty = true;
        private int count = 0;
        private long birthtime;

        public RenderPlane(RenderStrip[] strips, int y, int offsety, int startz, int count) {
            this.strips = strips;
            this.y = y;
            this.offsety = offsety;
            this.startz = startz;
            this.count = count;
            this.birthtime = System.currentTimeMillis();
        }

        public void refreshData(RenderPlane other) {
            this.strips = other.strips;
            this.y = other.y;
            this.offsety = other.offsety;
            this.startz = other.startz;
            this.count = other.count;
            this.dirty = true;
            this.birthtime = System.currentTimeMillis();
            super.cleanup();
        }

        public long getBirthtime() {
            return this.birthtime;
        }

        public int getCount() {
            return this.count;
        }

        public void markClean() {
            this.dirty = false;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public RenderStrip[] getStrips() {
            return this.strips;
        }

        public int getOffsety() {
            return this.offsety;
        }

        public int getY() {
            return this.y;
        }

        public int getStartz() {
            return this.startz;
        }
    }

    public static class RenderStrip {
        private final List<Pair<Integer, BlockState>> data = new ArrayList<Pair<Integer, BlockState>>();
        private final int x;
        private BlockState last;
        private int cnt = 0;

        public RenderStrip(int x) {
            this.x = x;
        }

        public int getX() {
            return this.x;
        }

        public List<Pair<Integer, BlockState>> getData() {
            return this.data;
        }

        public boolean isEmptyAt(int i, Map<BlockState, ShapeBlockInfo> palette) {
            if (i < 0) {
                return true;
            }
            if (i >= this.data.size()) {
                return true;
            }
            BlockState state = (BlockState)this.data.get(i).getValue();
            if (ShapeBlockInfo.getBlockInfo(palette, state).isNonSolid()) {
                return true;
            }
            return state == null;
        }

        public void add(BlockState state) {
            if (this.cnt == 0) {
                this.last = state;
                this.cnt = 1;
            } else if (this.last != state) {
                this.data.add((Pair<Integer, BlockState>)Pair.of((Object)this.cnt, (Object)this.last));
                this.last = state;
                this.cnt = 1;
            } else {
                ++this.cnt;
            }
        }

        public void close() {
            if (this.cnt > 0) {
                this.data.add((Pair<Integer, BlockState>)Pair.of((Object)this.cnt, (Object)this.last));
                this.cnt = 0;
            }
        }
    }

    public static class RenderElement {
        protected VertexBuffer vbo;

        public void cleanup() {
            if (this.vbo != null) {
                this.vbo.close();
                this.vbo = null;
            }
        }

        public void render() {
            if (this.vbo != null) {
                // empty if block
            }
        }

        public void createRenderList() {
        }

        public void performRenderToList() {
            vboBuffer.m_231175_();
            vboBuffer.m_85729_();
        }
    }
}

