/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.roughlyenoughprofessions.rei;

import com.mrbysco.roughlyenoughprofessions.compat.CompatibilityHelper;
import com.mrbysco.roughlyenoughprofessions.profession.ProfessionEntry;
import com.mrbysco.roughlyenoughprofessions.rei.ProfessionCategory;
import com.mrbysco.roughlyenoughprofessions.rei.ProfessionDisplayForge;
import java.util.LinkedList;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

@REIPluginClient
public class REPClientPlugin
implements REIClientPlugin {
    public static final CategoryIdentifier<ProfessionDisplayForge> PROFESSION = CategoryIdentifier.of((String)"roughlyenoughprofessions", (String)"plugins/profession");

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new ProfessionCategory());
        registry.addWorkstations(PROFESSION, new EntryStack[]{EntryStacks.of((ItemLike)Items.f_42616_), EntryStacks.of((ItemLike)Items.f_42601_)});
    }

    public void registerDisplays(DisplayRegistry registry) {
        LinkedList<ProfessionDisplayForge> entries = new LinkedList<ProfessionDisplayForge>();
        for (VillagerProfession profession : ForgeRegistries.VILLAGER_PROFESSIONS) {
            if (profession == VillagerProfession.f_35585_) continue;
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            LinkedList<ResourceLocation> knownItems = new LinkedList<ResourceLocation>();
            for (PoiType poiType : ForgeRegistries.POI_TYPES.getValues()) {
                if (!profession.f_219629_().test(ForgeRegistries.POI_TYPES.getHolder((Object)poiType).orElse(null))) continue;
                for (BlockState state : poiType.f_27325_()) {
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()));
                    if (block == null) continue;
                    ItemStack stack = CompatibilityHelper.compatibilityCheck(new ItemStack((ItemLike)block), ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)profession));
                    ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                    if (stack.m_41619_() || knownItems.contains(location)) continue;
                    stacks.add(stack);
                    knownItems.add(location);
                }
            }
            if (stacks.isEmpty()) continue;
            entries.add(new ProfessionDisplayForge(new ProfessionEntry(profession, stacks)));
        }
        entries.forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
    }
}

