/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.leveling;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketExperienceExchange {
    private final BlockPos pos;
    private final int amount;

    public PacketExperienceExchange(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.amount = buf.readInt();
    }

    public PacketExperienceExchange(BlockPos pos, int amount) {
        this.pos = pos;
        this.amount = amount;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.amount);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            int oneCost;
            IRelicItem relic;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level world = player.m_9236_();
            BlockEntity patt1362$temp = world.m_7702_(this.pos);
            if (!(patt1362$temp instanceof ResearchingTableTile)) {
                return;
            }
            ResearchingTableTile tile = (ResearchingTableTile)patt1362$temp;
            ItemStack stack = tile.getStack();
            Item patt1513$temp = stack.m_41720_();
            if (!(patt1513$temp instanceof IRelicItem) || (relic = (IRelicItem)patt1513$temp).isMaxLevel(stack)) {
                return;
            }
            int playerExperience = EntityUtils.getPlayerTotalExperience((Player)player);
            if (playerExperience <= 0) {
                return;
            }
            int exchanges = relic.getExchanges(stack);
            int level = relic.getLevel(stack);
            int cost = 5;
            int toAdd = 0;
            int toTake = 0;
            for (int i = 0; i < this.amount && playerExperience >= toTake + (oneCost = (int)((float)cost + (float)cost * ((float)(exchanges + i) * 0.01f))); ++i) {
                toAdd += (int)Math.ceil((float)relic.getExperienceBetweenLevels(stack, level, level + 1) / 100.0f);
                toTake += oneCost;
                relic.addExchanges(stack, 1);
            }
            player.m_6756_(-toTake);
            relic.addExperience((LivingEntity)player, stack, toAdd);
            world.m_7260_(this.pos, world.m_8055_(this.pos), world.m_8055_(this.pos), 2);
        });
        return true;
    }
}

