/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStorage;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    protected void init(Item.Properties properties, CallbackInfo ci) {
        Item item = (Item)this;
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            RelicStorage.RELICS.put(relic, relic.getRelicData());
        }
    }

    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")})
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected, CallbackInfo ci) {
        Object object;
        if (level.m_5776_() || !((object = stack.m_41720_()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)object;
        for (Map.Entry entry : relic.getRelicData().getAbilities().getAbilities().entrySet()) {
            String ability = (String)entry.getKey();
            if (relic.getAbilityCooldown(stack, ability) <= 0) continue;
            relic.addAbilityCooldown(stack, ability, -1);
        }
    }

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")})
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced, CallbackInfo ci) {
        this.relics$processTooltip(stack, level, tooltip);
    }

    @Unique
    @OnlyIn(value=Dist.CLIENT)
    private void relics$processTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip) {
        IRelicItem relic;
        Item item;
        block10: {
            block9: {
                item = stack.m_41720_();
                if (!(item instanceof IRelicItem)) break block9;
                relic = (IRelicItem)item;
                if (level != null && level.m_5776_()) break block10;
            }
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        tooltip.add((Component)Component.m_237113_((String)" "));
        if (relic.isItemResearched((Player)player)) {
            if (Screen.m_96638_()) {
                RelicData relicData = relic.getRelicData();
                if (relicData == null) {
                    return;
                }
                Map<String, AbilityData> abilities = relicData.getAbilities().getAbilities();
                tooltip.add((Component)Component.m_237113_((String)"\u25b6 ").m_130940_(ChatFormatting.DARK_GREEN).m_7220_((Component)Component.m_237115_((String)"tooltip.relics.relic.tooltip.abilities").m_130940_(ChatFormatting.GREEN)));
                for (Map.Entry<String, AbilityData> entry : abilities.entrySet()) {
                    String id = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
                    String name = entry.getKey();
                    if (!relic.canUseAbility(stack, name)) continue;
                    tooltip.add((Component)Component.m_237113_((String)"   \u25c6 ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237115_((String)("tooltip.relics." + id + ".ability." + name)).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237115_((String)("tooltip.relics." + id + ".ability." + name + ".description")).m_130940_(ChatFormatting.GRAY)));
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.relics.relic.tooltip.shift").m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.relics.relic.tooltip.table").m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237113_((String)" "));
    }
}

