/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class DissectionEntity
extends Entity {
    private static final EntityDataAccessor<Integer> LIFE_TIME = SynchedEntityData.m_135353_(DissectionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean isMaster = false;
    private int maxLifeTime;
    public List<UUID> entities = new ArrayList<UUID>();
    public List<UUID> blacklist = new ArrayList<UUID>();
    public boolean locked = true;
    public UUID pair;

    public int getLifeTime() {
        return (Integer)this.m_20088_().m_135370_(LIFE_TIME);
    }

    public void setLifeTime(int amount) {
        this.m_20088_().m_135381_(LIFE_TIME, (Object)amount);
    }

    public DissectionEntity(EntityType<?> pEntityType, Level level) {
        super(pEntityType, level);
        this.f_19794_ = true;
    }

    public DissectionEntity(Level level) {
        super((EntityType)EntityRegistry.DISSECTION.get(), level);
        this.f_19794_ = true;
    }

    @Nullable
    public DissectionEntity getPair() {
        DissectionEntity dissection;
        if (this.pair == null || this.m_9236_().m_5776_()) {
            return null;
        }
        Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.pair);
        return entity instanceof DissectionEntity ? (dissection = (DissectionEntity)entity) : null;
    }

    public void setPair(Entity entity) {
        if (!(entity instanceof DissectionEntity)) {
            return;
        }
        this.pair = entity.m_20148_();
    }

    public void m_8119_() {
        super.m_8119_();
        RandomSource random = this.m_9236_().m_213780_();
        this.m_20095_();
        if (this.f_19797_ > 5) {
            for (int i = 0; i < 5; ++i) {
                float step = Math.max(Math.min(this.getLifeTime() > 20 ? (float)(this.f_19797_ - 5) * 0.075f : (float)this.getLifeTime() * 0.075f, 1.0f), 0.0f);
                float mul = random.m_188501_() * 0.3f;
                Vec3 pos2 = this.m_20182_().m_82549_(this.m_20154_()).m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0).m_82520_((double)(MathUtils.randomFloat(random) * step), (double)(MathUtils.randomFloat(random) * step), (double)(MathUtils.randomFloat(random) * step));
                Vec3 angle = this.m_20154_().m_82541_().m_82542_((double)mul, (double)mul, (double)mul);
                this.m_9236_().m_7106_((ParticleOptions)ParticleUtils.constructSimpleSpark(new Color(150 + random.m_188503_(100), 100, 0), 0.2f + random.m_188501_() * 0.1f, 10 + random.m_188503_(20), 0.9f), pos2.m_7096_(), pos2.m_7098_(), pos2.m_7094_(), angle.m_7096_(), angle.m_7098_(), angle.m_7094_());
            }
        }
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.locked = false;
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        DissectionEntity pair = this.getPair();
        if (pair == null) {
            if (!this.isMaster() || this.getMaxLifeTime() == 0 || this.getLifeTime() != this.getMaxLifeTime()) {
                this.m_146870_();
            }
            return;
        }
        if (this.isMaster()) {
            int time = this.getLifeTime();
            if (time > 0) {
                this.setLifeTime(--time);
                pair.setLifeTime(time);
            } else {
                this.m_146870_();
            }
        }
        this.m_7618_(EntityAnchorArgument.Anchor.FEET, pair.m_20182_());
        Vec3 currentVec = this.m_20182_().m_82549_(this.m_20154_()).m_82520_(0.0, 1.25, 0.0);
        Vec3 nextVec = pair.m_20182_().m_82549_(pair.m_20154_()).m_82520_(0.0, 1.25, 0.0);
        int distance = (int)Math.round(currentVec.m_82554_(nextVec));
        Vec3 finalVec = currentVec.m_82549_(nextVec.m_82546_(currentVec).m_82541_().m_82542_((double)distance, (double)distance, (double)distance));
        distance = (int)Math.round(currentVec.m_82554_(finalVec));
        for (int j = 0; j < distance; ++j) {
            float x = (float)((finalVec.f_82479_ - currentVec.f_82479_) * (double)j / (double)distance + currentVec.f_82479_);
            float y = (float)((finalVec.f_82480_ - currentVec.f_82480_) * (double)j / (double)distance + currentVec.f_82480_);
            float z = (float)((finalVec.f_82481_ - currentVec.f_82481_) * (double)j / (double)distance + currentVec.f_82481_);
            BlockPos.m_121921_((AABB)new AABB(new BlockPos((int)x, (int)y, (int)z))).forEach(pos -> {
                if (serverLevel.m_8055_(pos).m_280555_()) {
                    this.locked = true;
                    serverLevel.m_8767_((ParticleOptions)ParticleUtils.constructSimpleSpark(new Color(255, random.m_188503_(50), 0), 0.1f, 10, 0.9f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), 1, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.025f);
                }
            });
        }
        if (this.locked) {
            this.entities.clear();
            return;
        }
        ArrayList<UUID> toRemoveFromEntities = new ArrayList<UUID>();
        for (UUID uuid : this.entities) {
            Entity target = serverLevel.m_8791_(uuid);
            if (!(target instanceof LivingEntity)) {
                toRemoveFromEntities.add(uuid);
                continue;
            }
            if (this.blacklist.contains(uuid)) continue;
            if (target.m_20182_().m_82554_(this.m_20182_()) > this.m_20182_().m_82554_(pair.m_20182_())) {
                toRemoveFromEntities.add(uuid);
                continue;
            }
            if (!serverLevel.m_45976_(LivingEntity.class, this.m_20191_()).contains(target)) {
                double mul = this.m_20182_().m_82554_(pair.m_20182_()) * (double)0.05f;
                Vec3 motion = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0).m_82546_(target.m_20182_()).m_82541_().m_82542_(mul, mul, mul);
                if (target instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)target;
                    NetworkHandler.sendToClient(new PacketPlayerMotion(motion.m_7096_(), motion.m_7098_(), motion.m_7094_()), player);
                } else {
                    target.m_20256_(motion);
                }
                target.f_19789_ = 0.0f;
                ((LivingEntity)target).m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.VANISHING.get(), 5, 0, false, false));
                serverLevel.m_8767_((ParticleOptions)ParticleUtils.constructSimpleSpark(new Color(150 + random.m_188503_(100), 100, 0), 0.2f, 20, 0.9f), target.m_20185_(), target.m_20186_() + 1.25, target.m_20189_(), Math.round(target.m_20206_() * 3.0f), (double)0.1f, (double)0.1f, (double)0.1f, (double)0.05f);
                continue;
            }
            this.blacklist.add(target.m_20148_());
            toRemoveFromEntities.add(target.m_20148_());
        }
        if (!toRemoveFromEntities.isEmpty()) {
            this.entities.removeAll(toRemoveFromEntities);
        }
        ArrayList<UUID> toRemoveFromBlacklist = new ArrayList<UUID>();
        for (UUID uuid : this.blacklist) {
            if (serverLevel.m_45976_(LivingEntity.class, this.m_20191_()).stream().map(Entity::m_20148_).toList().contains(uuid)) continue;
            toRemoveFromBlacklist.add(uuid);
        }
        if (!toRemoveFromBlacklist.isEmpty()) {
            this.blacklist.removeAll(toRemoveFromBlacklist);
        }
        for (LivingEntity target : serverLevel.m_45976_(LivingEntity.class, this.m_20191_())) {
            UUID uuid = target.m_20148_();
            if (this.blacklist.contains(uuid) || this.getPair().entities.contains(uuid)) continue;
            this.getPair().entities.add(uuid);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.isMaster()) {
            return;
        }
        DissectionEntity pair = this.getPair();
        if (pair == null) {
            return;
        }
        pair.setLifeTime(Math.min(pair.getLifeTime(), 20));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LIFE_TIME, (Object)100);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setMaxLifeTime(compound.m_128451_("maxLifeTime"));
        this.setMaster(compound.m_128471_("isMaster"));
        this.setLifeTime(compound.m_128451_("lifeTime"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("maxLifeTime", this.getMaxLifeTime());
        compound.m_128379_("isMaster", this.isMaster());
        compound.m_128405_("lifeTime", this.getLifeTime());
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setMaster(boolean isMaster) {
        this.isMaster = isMaster;
    }

    public int getMaxLifeTime() {
        return this.maxLifeTime;
    }

    public void setMaxLifeTime(int maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
    }
}

