/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.tooltip;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.events.common.TooltipDisplayEvent;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="relics", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TooltipBorderHandler {
    @SubscribeEvent
    public static void onTooltipDisplay(TooltipDisplayEvent event) {
        IRelicItem relic;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = event.getStack();
        Item item = stack.m_41720_();
        if (!(item instanceof IRelicItem) || !(relic = (IRelicItem)item).getStyleData().getTooltip().isTextured()) {
            return;
        }
        GuiGraphics graphics = event.getGraphics();
        PoseStack poseStack = graphics.m_280168_();
        int width = event.getWidth();
        int height = event.getHeight();
        int x = event.getX();
        int y = event.getY();
        String id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        ResourceLocation texture = new ResourceLocation("relics", "textures/gui/tooltip/frame/" + id + "_frame.png");
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        Minecraft.m_91087_().m_91097_().m_118506_(texture).m_117966_();
        int texWidth = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4096);
        int texHeight = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097);
        if (texHeight == 0 || texWidth == 0) {
            return;
        }
        int patternWidth = 160;
        int patternHeight = 64;
        int cornerWidth = 32;
        int cornerHeight = 32;
        int middleWidth = 96;
        int middleHeight = cornerHeight;
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        poseStack.m_85837_(0.0, 0.0, 410.0);
        int frame = (Integer)AnimationData.construct(texHeight, patternHeight, 2).getFrameByTime(player.f_19797_).getKey();
        int offset = patternHeight * frame;
        graphics.m_280163_(texture, x - cornerWidth / 2 - 3, y - cornerHeight / 2 - 3, 0.0f, (float)offset, cornerWidth, cornerHeight, texWidth, texHeight);
        graphics.m_280163_(texture, x + width - cornerWidth / 2 + 3, y - cornerHeight / 2 - 3, (float)(patternWidth - cornerWidth), (float)offset, cornerWidth, cornerHeight, texWidth, texHeight);
        graphics.m_280163_(texture, x - cornerWidth / 2 - 3, y + height - cornerHeight / 2 + 3, 0.0f, (float)(patternHeight - cornerHeight + offset), cornerWidth, cornerHeight, texWidth, texHeight);
        graphics.m_280163_(texture, x + width - cornerWidth / 2 + 3, y + height - cornerHeight / 2 + 3, (float)(patternWidth - cornerWidth), (float)(patternHeight - cornerHeight + offset), cornerWidth, cornerHeight, texWidth, texHeight);
        graphics.m_280163_(texture, x + (width - middleWidth) / 2, y - middleHeight + 1, (float)cornerWidth, (float)offset, middleWidth, middleHeight, texWidth, texHeight);
        graphics.m_280163_(texture, x + (width - middleWidth) / 2, y + height - 1, (float)cornerWidth, (float)(middleHeight + offset), middleWidth, middleHeight, texWidth, texHeight);
        texture = new ResourceLocation("relics", "textures/gui/tooltip/frame/" + id + "_star.png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        int xOff = 0;
        for (int i = 1; i < relic.getRelicQuality(stack) + 1; ++i) {
            boolean isAliquot = i % 2 == 1;
            float color = (float)((double)0.85f + Math.sin((double)player.f_19797_ * Math.ceil((float)i / 2.0f) * (double)0.075f) * (double)0.3f);
            RenderSystem.blendFunc((int)770, (int)1);
            RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
            graphics.m_280163_(texture, x + width / 2 - 14 + xOff, y - 10, (float)(isAliquot ? 0 : 3), 0.0f, isAliquot ? 3 : 2, 5, 5, 5);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            xOff += 3;
        }
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void onTooltipColorEvent(RenderTooltipEvent.Color event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        TooltipData tooltip = relic.getStyleData().getTooltip();
        if (tooltip.getBorderTop() != -1) {
            event.setBorderStart(tooltip.getBorderTop());
        }
        if (tooltip.getBorderBottom() != -1) {
            event.setBorderEnd(tooltip.getBorderBottom());
        }
        if (tooltip.getBackgroundTop() != -1) {
            event.setBorderStart(tooltip.getBackgroundTop());
        }
        if (tooltip.getBackgroundBottom() != -1) {
            event.setBackgroundEnd(tooltip.getBackgroundBottom());
        }
    }
}

