/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.relic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.leveling.PacketExperienceExchange;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class ExperienceExchangeWidget
extends AbstractDescriptionWidget
implements ITickingWidget,
IHoverableWidget {
    private final RelicDescriptionScreen screen;
    private int exchangeSpeed = 1;

    public ExperienceExchangeWidget(int x, int y, RelicDescriptionScreen screen) {
        super(x, y, 12, 16);
        this.screen = screen;
    }

    @Override
    public boolean isLocked() {
        IRelicItem relic;
        Item item = this.screen.stack.m_41720_();
        return !(item instanceof IRelicItem) || !(relic = (IRelicItem)item).isExchangeAvailable((Player)this.MC.f_91074_, this.screen.stack) || relic.isMaxLevel(this.screen.stack);
    }

    @Override
    public void m_5691_() {
        if (this.isLocked()) {
            this.exchangeSpeed = 1;
        }
    }

    @Override
    public void onTick() {
        LocalPlayer player = this.MC.f_91074_;
        if (player == null) {
            return;
        }
        RandomSource random = player.m_217043_();
        if (this.m_198029_()) {
            if (this.screen.ticksExisted % 10 == 0) {
                ParticleStorage.addParticle(this.screen, new ExperienceParticleData(this.isLocked() ? new Color(100 + random.m_188503_(100), 100 + random.m_188503_(100), 100 + random.m_188503_(100)) : new Color(200 + random.m_188503_(50), 150 + random.m_188503_(100), 0), this.m_252754_() + random.m_188503_(this.f_93618_), this.m_252907_() + random.m_188503_(this.f_93619_), 0.15f + random.m_188501_() * 0.25f, 100 + random.m_188503_(50)));
            }
            this.screen.gatherData();
        }
        if (this.isLocked() || !this.m_93696_() || !this.m_274382_()) {
            return;
        }
        if (player.f_36078_ > 0 || player.f_36079_ > 0) {
            if (this.screen.ticksExisted % 2 == 0) {
                ++this.exchangeSpeed;
            }
            NetworkHandler.sendToServer(new PacketExperienceExchange(this.screen.pos, (int)Math.ceil((float)this.exchangeSpeed / 4.0f)));
            this.MC.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11871_, (float)(1.0f + (float)this.exchangeSpeed * 0.02f)));
        }
    }

    public void m_7691_(double pMouseX, double pMouseY) {
        this.m_93692_(false);
        this.exchangeSpeed = 1;
    }

    public void m_87963_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        TextureManager manager = this.MC.m_91097_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RelicDescriptionScreen.TEXTURE);
        manager.m_174784_(RelicDescriptionScreen.TEXTURE);
        boolean isLocked = this.isLocked();
        guiGraphics.m_280163_(RelicDescriptionScreen.TEXTURE, this.m_252754_(), this.m_252907_(), isLocked ? 407.0f : 394.0f, 1.0f, this.f_93618_, this.f_93619_, 512, 512);
        if (this.f_93622_) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("relics", "textures/gui/description/exchange_highlight_" + (isLocked ? "locked" : "unlocked") + ".png"));
            RenderSystem.enableBlend();
            RenderUtils.renderAnimatedTextureFromCenter(guiGraphics.m_280168_(), this.m_252754_() + 6, this.m_252907_() + 7, 32.0f, 384.0f, 32.0f, 32.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2));
            RenderSystem.disableBlend();
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Item item = this.screen.stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        RelicData data = relic.getRelicData();
        if (data == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 100;
        int renderWidth = 0;
        int cost = relic.getExchangeCost(this.screen.stack);
        int experience = this.MC.f_91074_.f_36079_;
        MutableComponent negativeStatus = Component.m_237115_((String)"tooltip.relics.relic.status.negative").m_130940_(ChatFormatting.RED);
        MutableComponent positiveStatus = Component.m_237115_((String)"tooltip.relics.relic.status.positive").m_130940_(ChatFormatting.GREEN);
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237115_((String)"tooltip.relics.relic.exchange.description").m_130940_(ChatFormatting.BOLD), Component.m_237113_((String)" ")});
        if (relic.isMaxLevel(this.screen.stack)) {
            entries.add(Component.m_237113_((String)"\u25b6 ").m_7220_((Component)Component.m_237115_((String)"tooltip.relics.relic.exchange.locked")));
        } else {
            entries.add(Component.m_237110_((String)"tooltip.relics.relic.exchange.cost", (Object[])new Object[]{cost, cost >= experience ? negativeStatus : positiveStatus}));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = (this.MC.f_91062_.m_92852_((FormattedText)entry) + 4) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
        }
        int height = Math.round(tooltip.size() * 5);
        int renderX = this.m_252754_() + this.f_93618_ + 1;
        int renderY = mouseY - height / 2 - 9;
        ScreenUtils.drawTexturedTooltipBorder(guiGraphics, new ResourceLocation("relics", "textures/gui/tooltip/border/paper.png"), renderWidth, height, renderX, renderY);
        int yOff = 0;
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.m_280649_(this.MC.f_91062_, entry, (renderX + 9) * 2, (renderY + 9 + yOff) * 2, 4269832, false);
            yOff += 5;
        }
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
    }
}

