/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.util;

import com.google.common.collect.Iterables;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.impl.client.util.CyclingList;
import org.jetbrains.annotations.Nullable;

public class OriginalRetainingCyclingList<T>
implements CyclingList.Mutable<T> {
    private final Supplier<T> empty;
    @Nullable
    private CyclingList<T> backing = null;

    public OriginalRetainingCyclingList(Supplier<T> empty) {
        this.empty = empty;
    }

    @Override
    public List<T> get() {
        if (this.backing == null) {
            return List.of();
        }
        return (List)this.backing.get();
    }

    @Override
    public T peek() {
        if (this.backing == null) {
            return this.empty.get();
        }
        return this.backing.peek();
    }

    @Override
    public T previous() {
        if (this.backing == null) {
            return this.empty.get();
        }
        return this.backing.previous();
    }

    @Override
    public int nextIndex() {
        return this.backing == null ? 0 : this.backing.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.backing == null ? -1 : this.backing.previousIndex();
    }

    @Override
    public T next() {
        if (this.backing == null) {
            return this.empty.get();
        }
        return this.backing.next();
    }

    @Override
    public void add(T entry) {
        CyclingList<T> cyclingList = this.backing;
        if (cyclingList instanceof CyclingList.Mutable) {
            CyclingList.Mutable mutable = (CyclingList.Mutable)cyclingList;
            mutable.add(entry);
        } else if (this.backing == null) {
            this.backing = CyclingList.of(List.of(entry), this.empty);
        } else {
            CyclingList.Mutable<T> mutable = CyclingList.ofMutable(this.backing, this.empty);
            mutable.add(entry);
            this.backing = mutable;
        }
    }

    @Override
    public void resetToStart() {
        if (this.backing != null) {
            this.backing.resetToStart();
        }
    }

    @Override
    public int size() {
        return this.backing == null ? 0 : this.backing.size();
    }

    @Override
    public int currentIndex() {
        return this.backing == null ? 0 : this.backing.currentIndex();
    }

    @Override
    public void addAll(Collection<? extends T> entries) {
        if (!entries.isEmpty()) {
            CyclingList<T> cyclingList = this.backing;
            if (cyclingList instanceof CyclingList.Mutable) {
                CyclingList.Mutable mutable = (CyclingList.Mutable)cyclingList;
                mutable.addAll(entries);
            } else if (this.backing == null) {
                List<Object> list;
                if (entries instanceof List) {
                    List stacksAsList = (List)entries;
                    list = (List)entries;
                } else {
                    list = OriginalRetainingCyclingList.getListFromCollection(entries);
                }
                this.backing = CyclingList.of(list, this.empty);
            } else {
                CyclingList.Mutable<T> mutable = CyclingList.ofMutable(this.backing, this.empty);
                mutable.addAll(entries);
                this.backing = mutable;
            }
        }
    }

    @Override
    public void clear() {
        CyclingList<T> cyclingList = this.backing;
        if (cyclingList instanceof CyclingList.Mutable) {
            CyclingList.Mutable mutable = (CyclingList.Mutable)cyclingList;
            mutable.clear();
        } else {
            this.backing = null;
        }
    }

    public void setBacking(@Nullable CyclingList<T> backing) {
        this.backing = backing;
    }

    private static <T> AbstractList<T> getListFromCollection(final Collection<? extends T> entries) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return Iterables.get((Iterable)entries, (int)index);
            }

            @Override
            public int size() {
                return entries.size();
            }

            @Override
            public Iterator<T> iterator() {
                return entries.iterator();
            }

            @Override
            public boolean add(T element) {
                return entries.add(element);
            }

            @Override
            public void add(int index, T element) {
                this.add((T)element);
            }

            @Override
            public T remove(int index) {
                Object stack = this.get(index);
                return stack == null && entries.remove(stack) ? (Object)stack : null;
            }
        };
    }

    public CyclingList<T> getBacking() {
        if (this.backing == null) {
            return CyclingList.of(this.empty);
        }
        return this.backing;
    }
}

