/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.EntryPanelOrdering;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.view.Views;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.config.collapsible.CollapsibleConfigManager;
import me.shedaniel.rei.impl.client.search.AsyncSearchManager;
import me.shedaniel.rei.impl.client.search.collapsed.CollapsedEntriesCache;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsedStack;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsibleEntryRegistryImpl;
import me.shedaniel.rei.impl.common.util.HNEntryStackWrapper;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class EntryListSearchManager {
    private static final Comparator<? super HashedEntryStackWrapper> ENTRY_NAME_COMPARER = Comparator.comparing(stack -> stack.unwrap().asFormatStrippedText().getString());
    public static final EntryListSearchManager INSTANCE = new EntryListSearchManager();
    private final AsyncSearchManager searchManager = new AsyncSearchManager(EntryListSearchManager::getAllEntriesContextually, () -> {
        LongOpenHashSet workingItems;
        boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled();
        LongOpenHashSet longOpenHashSet = workingItems = checkCraftable ? new LongOpenHashSet() : null;
        if (checkCraftable) {
            for (EntryStack<?> stack2 : Views.getInstance().findCraftableEntriesByMaterials()) {
                workingItems.add(EntryStacks.hashExact(stack2));
            }
        }
        return checkCraftable ? arg_0 -> EntryListSearchManager.lambda$new$1((LongSet)workingItems, arg_0) : stack -> true;
    }, HashedEntryStackWrapper::normalize);

    private static List<HNEntryStackWrapper> getAllEntriesContextually(SearchFilter filter) {
        if (EntryRegistry.getInstance().isReloading()) {
            return List.of();
        }
        if (ConfigObject.getInstance().isHidingEntryPanelIfIdle() && filter.getFilter().isEmpty()) {
            return List.of();
        }
        return ((EntryRegistryImpl)EntryRegistry.getInstance()).getPreFilteredComplexList();
    }

    public void update(String searchTerm, boolean ignoreLastSearch, Consumer<List<Object>> update) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (ignoreLastSearch) {
            this.searchManager.markDirty();
        }
        this.searchManager.updateFilter(searchTerm);
        if (this.searchManager.isDirty()) {
            this.searchManager.getAsync((list, filter) -> {
                if (!filter.getFilter().equals(searchTerm)) {
                    return;
                }
                if (this.searchManager.filter == null || this.searchManager.filter != filter) {
                    return;
                }
                InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Search \"%s\" Used [%s]: %s", filter.getFilter(), Thread.currentThread().toString(), stopwatch.toString());
                List<Object> finalList = this.collapse(this.copyAndOrder((List<HashedEntryStackWrapper>)list), () -> this.searchManager.filter != null && this.searchManager.filter == filter);
                InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Search \"%s\" Used and Applied [%s]: %s", filter.getFilter(), Thread.currentThread().toString(), stopwatch.stop().toString());
                Minecraft.m_91087_().m_18707_(() -> {
                    if (this.searchManager.filter == null || this.searchManager.filter != filter) {
                        return;
                    }
                    update.accept(finalList);
                });
            });
        }
    }

    private List<HashedEntryStackWrapper> copyAndOrder(List<HashedEntryStackWrapper> list) {
        list = new ArrayList<HashedEntryStackWrapper>(list);
        EntryPanelOrdering ordering = ConfigObject.getInstance().getItemListOrdering();
        if (ordering == EntryPanelOrdering.NAME) {
            list.sort(ENTRY_NAME_COMPARER);
        }
        if (!ConfigObject.getInstance().isItemListAscending()) {
            Collections.reverse(list);
        }
        return list;
    }

    private List<Object> collapse(final List<HashedEntryStackWrapper> stacks, BooleanSupplier isValid) {
        CollapsibleEntryRegistryImpl collapsibleRegistry = (CollapsibleEntryRegistryImpl)CollapsibleEntryRegistry.getInstance();
        HashMap<CollapsibleEntryRegistryImpl.Entry, @Nullable V> entries = new HashMap();
        CollapsibleConfigManager.CollapsibleConfigObject collapsibleConfig = CollapsibleConfigManager.getInstance().getConfig();
        for (CollapsibleEntryRegistryImpl.Entry entry : collapsibleRegistry.getEntries()) {
            if (collapsibleConfig.disabledGroups.contains(entry.getId())) continue;
            entries.put(entry, null);
        }
        for (CollapsibleEntryRegistryImpl.Entry entry : collapsibleRegistry.getCustomEntries()) {
            if (collapsibleConfig.disabledGroups.contains(entry.getId())) continue;
            entries.put(entry, null);
        }
        if (entries.isEmpty()) {
            return new AbstractList<EntryStack<?>>(){

                @Override
                public int size() {
                    return stacks.size();
                }

                @Override
                public EntryStack<?> get(int i) {
                    return ((HashedEntryStackWrapper)stacks.get(i)).unwrap();
                }

                @Override
                public Iterator<EntryStack<?>> iterator() {
                    return Iterators.transform(stacks.iterator(), HashedEntryStackWrapper::unwrap);
                }
            };
        }
        if (!isValid.getAsBoolean()) {
            return List.of();
        }
        ArrayList<Object> list = new ArrayList<Object>(stacks.size() + 10);
        int i = 0;
        for (HashedEntryStackWrapper wrapper : stacks) {
            long hashExact = wrapper.hashExact();
            EntryStack<?> stack = wrapper.unwrap();
            boolean matchedAny = false;
            Set<ResourceLocation> locations = CollapsedEntriesCache.getInstance().getEntries(hashExact);
            for (Map.Entry entry : entries.entrySet()) {
                boolean matches;
                CollapsibleEntryRegistryImpl.Entry entry2 = (CollapsibleEntryRegistryImpl.Entry)entry.getKey();
                if (!entry2.canCache()) {
                    matches = entry2.getMatcher().matches(stack, hashExact);
                } else {
                    boolean bl = matches = locations != null && locations.contains(entry2.getId());
                }
                if (!matches) continue;
                CollapsedStack collapsed = (CollapsedStack)entry.getValue();
                if (collapsed == null) {
                    ArrayList ingredient = new ArrayList();
                    ingredient.add(stack);
                    collapsed = new CollapsedStack(ingredient, entry2);
                    entry.setValue(collapsed);
                    list.add(collapsed);
                } else {
                    collapsed.getIngredient().add(stack);
                }
                matchedAny = true;
            }
            if (i++ % 50 == 0 && !isValid.getAsBoolean()) {
                return List.of();
            }
            if (matchedAny) continue;
            list.add(stack);
        }
        return list;
    }

    public AsyncSearchManager getSearchManager() {
        return this.searchManager;
    }

    public boolean matches(EntryStack<?> stack) {
        return this.searchManager.matches(stack);
    }

    private static /* synthetic */ boolean lambda$new$1(LongSet workingItems, HashedEntryStackWrapper stack) {
        return workingItems.contains(stack.hashExact());
    }
}

