/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.propellerhats.items;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.przemyk.propellerhats.PropHatsMod;
import xyz.przemyk.propellerhats.client.PropellerHatRenderProperties;
import xyz.przemyk.propellerhats.energy.CapabilityProviderEnergy;
import xyz.przemyk.propellerhats.energy.ItemEnergyStorage;

public class PropellerHatItem
extends ArmorItem {
    public final int energyCapacity;
    public final int energyUsage;
    public final float speed;

    public PropellerHatItem(ArmorMaterial materialIn, Item.Properties builderIn, int energyCapacity, int energyUsage, float speed) {
        super(materialIn, ArmorItem.Type.HELMET, builderIn);
        this.energyCapacity = energyCapacity;
        this.energyUsage = energyUsage;
        this.speed = speed;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(PropellerHatRenderProperties.INSTANCE);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)this);
        if (registryName == null) {
            return null;
        }
        return registryName.m_135827_() + ":textures/models/armor/" + registryName.m_135815_() + ".png";
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CapabilityProviderEnergy(new ItemEnergyStorage(stack, this.energyCapacity));
    }

    public int m_142159_(ItemStack stack) {
        return 3029;
    }

    public int m_142158_(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(energy -> {
            int capacity = energy.getMaxEnergyStored();
            return 13 - (int)((float)(capacity - energy.getEnergyStored()) * 13.0f) / capacity;
        }).orElse(0);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!player.m_5833_() && PropHatsMod.isHoldingUp(player) && (this.energyUsage == 0 || stack.getCapability(ForgeCapabilities.ENERGY).map(energy -> energy.extractEnergy(this.energyUsage, false) > 0).orElse(false).booleanValue())) {
            Vec3 motion = player.m_20184_();
            if (motion.f_82480_ < (double)this.speed + 0.2) {
                player.m_20334_(motion.f_82479_, motion.f_82480_ + (double)this.speed, motion.f_82481_);
                player.f_19789_ = 0.0f;
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (ForgeCapabilities.ENERGY != null) {
            stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> tooltip.add((Component)Component.m_237110_((String)"text.propellerhats.energy", (Object[])new Object[]{energy.getEnergyStored()})));
        }
    }
}

