/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class JEIMemoryEssenceCategory
extends AbstractPNCCategory<MemoryEssenceRecipe> {
    public JEIMemoryEssenceCategory() {
        super(RecipeTypes.MEMORY_ESSENCE, new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), 1000).getDisplayName(), (IDrawable)JEIMemoryEssenceCategory.guiHelper().createDrawable(Textures.GUI_JEI_MEMORY_ESSENCE, 0, 0, 146, 73), JEIMemoryEssenceCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.MEMORY_ESSENCE_BUCKET.get())));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MemoryEssenceRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 54, 29).addItemStack(recipe.input1)).addTooltipCallback((IRecipeSlotTooltipCallback)new Tooltip(recipe, 0));
        if (!recipe.input2.m_41619_()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 76, 29).addItemStack(recipe.input2)).addTooltipCallback((IRecipeSlotTooltipCallback)new Tooltip(recipe, 1));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 112, 29).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, Collections.singletonList(new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), 1000)));
    }

    public void draw(MemoryEssenceRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        Font fr = Minecraft.m_91087_().f_91062_;
        int ratio = XPFluidManager.getInstance().getXPRatio((Fluid)ModFluids.MEMORY_ESSENCE.get());
        String s = "1 XP = " + ratio + " mB";
        int w = fr.m_92895_(s);
        graphics.m_280056_(fr, s, (this.getBackground().getWidth() - w) / 2, 0, 0x404040, false);
    }

    static List<MemoryEssenceRecipe> getAllRecipes() {
        return ImmutableList.of((Object)new MemoryEssenceRecipe((ItemLike)ModItems.MEMORY_STICK.get(), null), (Object)new MemoryEssenceRecipe((ItemLike)ModBlocks.AERIAL_INTERFACE.get(), (ItemLike)ModUpgrades.DISPENSER.get().getItem()), (Object)new MemoryEssenceRecipe((ItemLike)ModItems.DRONE.get(), (ItemLike)ModItems.PROGRAMMING_PUZZLE.get()).setTooltipKey(1, "pneumaticcraft.gui.jei.tooltip.droneImportOrbs"));
    }

    static class MemoryEssenceRecipe {
        final ItemStack input1;
        final ItemStack input2;
        final String[] tooltips = new String[]{"", ""};

        public MemoryEssenceRecipe(ItemLike input1, ItemLike input2) {
            this.input1 = new ItemStack(input1);
            this.input2 = input2 == null ? ItemStack.f_41583_ : new ItemStack(input2);
        }

        public MemoryEssenceRecipe setTooltipKey(int slot, String tooltipKey) {
            this.tooltips[slot] = tooltipKey;
            return this;
        }

        public String getTooltipKey(int slot) {
            return slot >= 0 && slot <= 2 ? this.tooltips[slot] : "";
        }
    }

    private record Tooltip(MemoryEssenceRecipe recipe, int slot) implements IRecipeSlotTooltipCallback
    {
        public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
            String tooltipKey = this.recipe.getTooltipKey(this.slot);
            if (!tooltipKey.isEmpty()) {
                tooltip.addAll(PneumaticCraftUtils.splitStringComponent(ChatFormatting.GREEN + I18n.m_118938_((String)tooltipKey, (Object[])new Object[0])));
            }
        }
    }
}

