/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketJetBootsStateSync;
import net.minecraft.world.entity.player.Player;

public class JetBootsStateTracker {
    private static final JetBootsStateTracker clientTracker = new JetBootsStateTracker();
    private static final JetBootsStateTracker serverTracker = new JetBootsStateTracker();
    private final Map<UUID, JetBootsState> stateMap = new HashMap<UUID, JetBootsState>();

    public static JetBootsStateTracker getClientTracker() {
        return clientTracker;
    }

    public static JetBootsStateTracker getServerTracker() {
        return serverTracker;
    }

    public static JetBootsStateTracker getTracker(Player player) {
        return player.m_9236_().f_46443_ ? JetBootsStateTracker.getClientTracker() : JetBootsStateTracker.getServerTracker();
    }

    private JetBootsStateTracker() {
    }

    public void setJetBootsState(Player player, boolean enabled, boolean active, boolean builderMode) {
        if (!player.m_9236_().f_46443_) {
            JetBootsState state = this.stateMap.computeIfAbsent(player.m_20148_(), uuid -> new JetBootsState(false, false, false));
            boolean sendPacket = state.enabled != enabled || state.active != active || state.builderMode != builderMode;
            state.enabled = enabled;
            state.active = active;
            state.builderMode = builderMode;
            if (sendPacket) {
                NetworkHandler.sendToAllTracking(new PacketJetBootsStateSync(player, state), player.m_9236_(), player.m_20183_());
            }
        }
    }

    public void setJetBootsState(UUID playerId, JetBootsState state) {
        this.stateMap.put(playerId, state);
    }

    public JetBootsState getJetBootsState(Player player) {
        return this.stateMap.getOrDefault(player.m_20148_(), new JetBootsState(false, false, false));
    }

    public static class JetBootsState {
        private boolean enabled;
        private boolean active;
        private boolean builderMode;

        public JetBootsState(boolean enabled, boolean active, boolean builderMode) {
            this.enabled = enabled;
            this.active = active;
            this.builderMode = builderMode;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean isBuilderMode() {
            return this.builderMode;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setBuilderMode(boolean builderMode) {
            this.builderMode = builderMode;
        }

        public boolean shouldRotatePlayer() {
            return this.enabled && this.active && !this.builderMode;
        }

        public String toString() {
            return String.format("[en=%b,ac=%b,bu=%b]", this.enabled, this.active, this.builderMode);
        }
    }
}

