/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.utilities;

import java.util.List;
import net.kaneka.planttech2.crops.TemperatureTolerance;
import net.kaneka.planttech2.gui.GuidePlantsScreen;
import net.kaneka.planttech2.gui.guide.GuideScreen;
import net.kaneka.planttech2.items.BiomassContainerItem;
import net.kaneka.planttech2.items.GuideItem;
import net.kaneka.planttech2.items.upgradeable.MultitoolItem;
import net.kaneka.planttech2.items.upgradeable.RangedWeaponItem;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PTClientUtil {
    private static final ResourceLocation DRILLING_PREDICATE = new ResourceLocation("planttech2", "drilling");
    public static final ResourceLocation FILLED_PREDICATE = new ResourceLocation("planttech2", "filled");
    private static final ResourceLocation PULL_PREDICATE = new ResourceLocation("planttech2", "pull");
    private static final ResourceLocation PULLING_PREDICATE = new ResourceLocation("planttech2", "pulling");
    private static final ResourceLocation THERMOMETER_TEMPERATURE_PREDICATE = new ResourceLocation("planttech2", "temperature");

    public static void drawJEIBiomass(int biomass, GuiGraphics mStack, int width) {
        if (biomass > 0) {
            mStack.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)String.valueOf(biomass)).m_130946_(" ").m_130946_(Component.m_237115_((String)"fluid.biomass").getString()).m_130940_(ChatFormatting.GREEN), width / 2, 19, -8355712);
        }
    }

    public static void drawCenteredString(GuiGraphics mStack, Font font, Component string, float posX, float posY, boolean shadow) {
        int c = string.m_7383_().m_131135_() == null ? 0xFFFFFF : string.m_7383_().m_131135_().m_131265_();
        mStack.drawString(font, string.m_7532_(), posX - (float)font.m_92852_((FormattedText)string) / 2.0f, posY, c, shadow);
    }

    public static void drawCenteredString(GuiGraphics mStack, Font font, String string, int posX, int posY, int colour, boolean shadow) {
        mStack.drawString(font, string, (float)posX - (float)font.m_92895_(string) / 2.0f, (float)posY, colour, shadow);
    }

    public static void addAllItemModelsOverrides() {
        ItemProperties.register((Item)((Item)ModItems.MULTITOOL.get()), (ResourceLocation)DRILLING_PREDICATE, (stack, world, entity, seed) -> entity == null || !(stack.m_41720_() instanceof MultitoolItem) ? 0.0f : (float)(entity.f_19797_ % 4 + 1));
        ItemProperties.register((Item)((Item)ModItems.BIOMASSCONTAINER.get()), (ResourceLocation)FILLED_PREDICATE, (stack, world, entity, seed) -> BiomassContainerItem.getFillLevelModel(stack));
        ItemProperties.register((Item)((Item)ModItems.CYBERBOW.get()), (ResourceLocation)PULL_PREDICATE, (stack, world, entity, seed) -> entity == null || !(entity.m_21211_().m_41720_() instanceof RangedWeaponItem) ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) / 20.0f);
        ItemProperties.register((Item)((Item)ModItems.CYBERBOW.get()), (ResourceLocation)PULLING_PREDICATE, (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)ModItems.THERMOMETER.get()), (ResourceLocation)THERMOMETER_TEMPERATURE_PREDICATE, (stack, world, entity, seed) -> {
            if (world != null && entity != null) {
                float temp = ((Biome)world.m_204166_(entity.m_20183_()).get()).getModifiedClimateSettings().f_47681_();
                if (TemperatureTolerance.EXTREME_COLD.inRange(temp)) {
                    return 0.1f;
                }
                if (TemperatureTolerance.COLD.inRange(temp)) {
                    return 0.1f;
                }
                if (TemperatureTolerance.NORMAL.inRange(temp)) {
                    return 0.2f;
                }
                if (TemperatureTolerance.WARM.inRange(temp)) {
                    return 0.3f;
                }
            }
            return 0.4f;
        });
    }

    public static void openGuideScreen(GuideItem guide) {
        Screen screen = guide == ModItems.GUIDE_PLANTS.get() ? new GuidePlantsScreen() : new GuideScreen();
        PTClientUtil.openScreen(screen);
    }

    public static void openScreen(Screen screen) {
        Minecraft.m_91087_().m_91152_(screen);
    }

    public static int getBarWidthForEnergyItem(ItemStack stack) {
        return PTCommonUtil.tryAccessEnergyValue((ICapabilityProvider)stack, storage -> (int)(13.0f * ((float)storage.getEnergyStored() / (float)storage.getMaxEnergyStored())), 13);
    }

    public static void appendEnergyTooltip(ItemStack stack, List<Component> tooltip) {
        PTCommonUtil.tryAccessEnergy((ICapabilityProvider)stack, cap -> tooltip.add((Component)Component.m_237110_((String)"planttech2.info.energy", (Object[])new Object[]{cap.getEnergyStored() + "/" + cap.getMaxEnergyStored()})));
    }
}

