/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.kaneka.planttech2.utilities.PlantTechConstants;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"planttech2");
    private static final Map<RegistryObject<CreativeModeTab>, List<Supplier<ItemStack>>> ITEMS_MAP = new HashMap<RegistryObject<CreativeModeTab>, List<Supplier<ItemStack>>>();
    public static final RegistryObject<CreativeModeTab> MAIN = ModCreativeTabs.tab("main", () -> (ItemLike)ModItems.WRENCH.get());
    public static final RegistryObject<CreativeModeTab> BLOCKS = ModCreativeTabs.tabSearchable("blocks", () -> (ItemLike)ModBlocks.KANEKIUM_BLOCK.get());
    public static final RegistryObject<CreativeModeTab> MACHINES = ModCreativeTabs.tab("machines", () -> (ItemLike)ModBlocks.SOLARGENERATOR.get());
    public static final RegistryObject<CreativeModeTab> SEEDS = ModCreativeTabs.tabSearchable("seeds", () -> CropTypes.DIAMOND_CROP.getSeed());
    public static final RegistryObject<CreativeModeTab> PARTICLES = ModCreativeTabs.tabSearchable("particles", () -> (ItemLike)ModItems.COLOR_PARTICLES.get());
    public static final RegistryObject<CreativeModeTab> TOOLS_AND_ARMOR = ModCreativeTabs.tab("toolsandarmor", () -> (ItemLike)ModItems.CYBERARMOR_CHEST.get());
    public static final RegistryObject<CreativeModeTab> CHIPS = ModCreativeTabs.tabSearchable("chips", () -> (ItemLike)ModItems.CAPACITYUPGRADE_TIER_1.get());

    private static <I extends ItemLike, S extends Supplier<I>> RegistryObject<CreativeModeTab> tab(String name, S icon) {
        return TABS.register(name, () -> CreativeModeTab.builder().m_257737_(() -> ModCreativeTabs.lambda$tab$7((Supplier)icon)).withTabsBefore(PlantTechConstants.VANILLA_TABS.toArray(new ResourceKey[0])).m_257941_((Component)Component.m_237115_((String)("itemGroup.planttech2_" + name))).m_257652_());
    }

    private static <I extends ItemLike, S extends Supplier<I>> RegistryObject<CreativeModeTab> tabSearchable(String name, S icon) {
        return TABS.register(name, () -> CreativeModeTab.builder().m_257737_(() -> ModCreativeTabs.lambda$tabSearchable$9((Supplier)icon)).withSearchBar().withTabsBefore(PlantTechConstants.VANILLA_TABS.toArray(new ResourceKey[0])).m_257941_((Component)Component.m_237115_((String)("itemGroup.planttech2_" + name))).m_257652_());
    }

    public static <I extends Item, T extends Supplier<I>> T putItem(RegistryObject<CreativeModeTab> category, T item) {
        ITEMS_MAP.computeIfAbsent(category, e -> new ArrayList()).add(() -> new ItemStack((ItemLike)item.get()));
        return item;
    }

    public static void putItemStack(RegistryObject<CreativeModeTab> category, Supplier<ItemStack> item) {
        ITEMS_MAP.computeIfAbsent(category, e -> new ArrayList()).add(item);
    }

    @SubscribeEvent
    public static void registerCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        ITEMS_MAP.keySet().stream().filter(e -> e != null && e.getKey().equals((Object)event.getTabKey())).findFirst().ifPresent(e -> event.m_246601_(PTCommonUtil.collect((Collection)ITEMS_MAP.get(e), Supplier::get)));
    }

    private static /* synthetic */ ItemStack lambda$tabSearchable$9(Supplier icon) {
        return new ItemStack((ItemLike)icon.get());
    }

    private static /* synthetic */ ItemStack lambda$tab$7(Supplier icon) {
        return new ItemStack((ItemLike)icon.get());
    }
}

