/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.utilities;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.kaneka.planttech2.PlantTechMain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public abstract class BaseReloadListener<T>
extends SimpleJsonResourceReloadListener {
    private final String name;
    protected final Gson gson;

    public BaseReloadListener(String name, Gson gson, String folder) {
        super(gson, folder);
        this.name = name;
        this.gson = gson;
    }

    protected void apply(Map<ResourceLocation, JsonElement> elementMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        PlantTechMain.LOGGER.debug("Loading " + this.m_7812_());
        HashMap<ResourceLocation, Supplier<T>> map = new HashMap<ResourceLocation, Supplier<T>>();
        for (ResourceLocation crop : elementMap.keySet()) {
            try {
                JsonElement element = elementMap.get(crop);
                if (!CraftingHelper.processConditions((JsonObject)GsonHelper.m_13918_((JsonElement)element, (String)"top element"), (String)"conditions", (ICondition.IContext)ICondition.IContext.EMPTY)) {
                    PlantTechMain.LOGGER.debug("Skipping loading " + this.name + " {} as it's conditions were not met", (Object)crop);
                    continue;
                }
                map.put(crop, () -> this.fromJson(element));
            }
            catch (JsonSyntaxException | IllegalArgumentException ex) {
                PlantTechMain.LOGGER.error("Error while loading " + this.name + " {}", (Object)crop, (Object)ex);
            }
        }
        this.postLoading(map);
    }

    protected abstract T fromJson(JsonElement var1);

    protected void postLoading(Map<ResourceLocation, Supplier<T>> map) {
    }
}

