/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.utilities;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseDataProvider<T>
implements DataProvider {
    protected static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final PackOutput dataGenerator;
    protected final Function<T, ResourceLocation> locationGetter;
    protected final List<T> data = new ArrayList<T>();

    public BaseDataProvider(PackOutput generator, Function<T, ResourceLocation> locationGetter) {
        this.dataGenerator = generator;
        this.locationGetter = locationGetter;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        Path path = this.dataGenerator.m_245114_();
        List<Object> entryData = this.getData();
        this.validate(entryData);
        ArrayList completables = new ArrayList();
        entryData.forEach(entry -> {
            Path outputFile = this.getPath(path, this.locationGetter.apply(entry));
            try {
                completables.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)this.toJson(entry), (Path)outputFile));
            }
            catch (Exception ioexception) {
                LOGGER.error("Couldn't save " + this.m_6055_() + " {}", (Object)outputFile, (Object)ioexception);
            }
        });
        return CompletableFuture.allOf(completables.toArray(new CompletableFuture[0]));
    }

    protected static ResourceLocation modLoc(String path) {
        return new ResourceLocation("planttech2", path);
    }

    protected abstract void validate(List<T> var1);

    protected abstract List<T> getData();

    protected abstract Path getPath(Path var1, ResourceLocation var2);

    protected abstract JsonElement toJson(T var1);
}

