/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.recipes.recipeclasses;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.kaneka.planttech2.recipes.ModRecipeSerializers;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ChipalyzerRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack chip;
    private final Ingredient input;
    @Nullable
    private final Enchantment enchantment;
    private final ItemStack output;

    public ChipalyzerRecipe(ResourceLocation id, ItemStack chip, @Nullable Ingredient input, @Nullable Enchantment enchantment, ItemStack output) {
        this.id = id;
        this.chip = chip;
        this.input = input == null ? Ingredient.f_43901_ : input;
        this.enchantment = enchantment;
        this.output = output;
    }

    public ItemStack getChip() {
        return this.chip;
    }

    public Ingredient getInput() {
        return this.input;
    }

    @Nullable
    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public boolean compare(ItemStack chip, ItemStack stack) {
        if (!stack.m_41619_() && !chip.m_41619_()) {
            List<Enchantment> stackench;
            if (this.enchantment != null && (stackench = this.getEnchList(stack)).contains(this.enchantment)) {
                return true;
            }
            if (!this.input.m_43947_()) {
                return this.input.test(stack);
            }
        }
        return false;
    }

    public List<Enchantment> getEnchList(ItemStack stack) {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        if (stack != null && !stack.m_41619_()) {
            if (stack.m_41720_() == Items.f_42690_) {
                for (Tag nbt : EnchantedBookItem.m_41163_((ItemStack)stack)) {
                    ResourceLocation ench;
                    CompoundTag compoundTag;
                    if (!(nbt instanceof CompoundTag) || !(compoundTag = (CompoundTag)nbt).m_128441_("id") || !ForgeRegistries.ENCHANTMENTS.containsKey(ench = new ResourceLocation(compoundTag.m_128461_("id")))) continue;
                    list.add((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ench));
                }
            } else {
                list.addAll(EnchantmentHelper.m_44831_((ItemStack)stack).keySet());
            }
        }
        return list;
    }

    public List<Ingredient> getComponents() {
        ArrayList<Ingredient> components = new ArrayList<Ingredient>();
        components.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.chip}));
        if (this.input.m_43947_() && this.enchantment != null) {
            ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
            book.m_41663_(this.enchantment, 1);
            components.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{book}));
        } else {
            components.add(this.input);
        }
        return components;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.input.test(inv.m_8020_(0));
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return width == height && width == 1;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.CHIPALYZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.CHIPALYZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<ChipalyzerRecipe> {
        public ChipalyzerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.f_43901_;
            Enchantment enchantment = null;
            if (json.has("input")) {
                JsonObject inputobject = json.getAsJsonObject("input");
                if (inputobject.has("enchantment")) {
                    ResourceLocation id = new ResourceLocation(inputobject.get("enchantment").getAsString());
                    if (ForgeRegistries.ENCHANTMENTS.containsKey(id)) {
                        enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id);
                    }
                } else {
                    input = Ingredient.m_43917_((JsonElement)inputobject);
                }
            } else {
                throw new JsonParseException("Input cannot be empty!");
            }
            return new ChipalyzerRecipe(recipeId, CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("chip"), (boolean)true, (boolean)true), input, enchantment, CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("result"), (boolean)true, (boolean)true));
        }

        public ChipalyzerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack chip = buffer.m_130267_();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            String ench = buffer.m_130277_();
            Enchantment enchantment = ench.equals("null") ? null : (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(ench));
            ItemStack result = buffer.m_130267_();
            return new ChipalyzerRecipe(recipeId, chip, input, enchantment, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, ChipalyzerRecipe recipe) {
            buffer.m_130055_(recipe.chip);
            recipe.input.m_43923_(buffer);
            if (recipe.enchantment != null) {
                buffer.m_130070_(ForgeRegistries.ENCHANTMENTS.getKey((Object)recipe.enchantment).toString());
            } else {
                buffer.m_130070_("null");
            }
            buffer.m_130055_(recipe.output);
        }
    }
}

