/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.packets;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.kaneka.planttech2.blocks.entity.machine.CompressorBlockEntity;
import net.kaneka.planttech2.blocks.entity.machine.MachineBulbReprocessorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ButtonPressMessage {
    private final int x;
    private final int y;
    private final int z;
    private final int buttonId;

    public ButtonPressMessage(int x, int y, int z, int buttonId) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.buttonId = buttonId;
    }

    public static void encode(ButtonPressMessage pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.x);
        buf.writeInt(pkt.y);
        buf.writeInt(pkt.z);
        buf.writeInt(pkt.buttonId);
    }

    public static ButtonPressMessage decode(ByteBuf buf) {
        return new ButtonPressMessage(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(ButtonPressMessage pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity te;
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            BlockPos pos = new BlockPos(pkt.x, pkt.y, pkt.z);
            int buttonId = pkt.buttonId;
            if (serverPlayer != null && serverPlayer.m_9236_().m_46805_(pos) && (te = serverPlayer.m_9236_().m_7702_(pos)) != null) {
                if (te instanceof CompressorBlockEntity) {
                    CompressorBlockEntity cbe = (CompressorBlockEntity)te;
                    cbe.setSelectedId(buttonId);
                } else if (te instanceof MachineBulbReprocessorBlockEntity) {
                    MachineBulbReprocessorBlockEntity mbrte = (MachineBulbReprocessorBlockEntity)te;
                    mbrte.setSelectedId(buttonId);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

