/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.kaneka.planttech2.inventory.ItemUpgradeableMenu;
import net.kaneka.planttech2.items.armors.ArmorBaseItem;
import net.kaneka.planttech2.items.armors.CustomArmorMaterial;
import net.kaneka.planttech2.items.upgradeable.IUpgradeable;
import net.kaneka.planttech2.items.upgradeable.InventoryEnergyProvider;
import net.kaneka.planttech2.items.upgradeable.UpgradeChipItem;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.kaneka.planttech2.utilities.NBTHelper;
import net.kaneka.planttech2.utilities.PTClientUtil;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.kaneka.planttech2.utilities.PlantTechConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class UpgradeableArmorItem
extends ArmorBaseItem
implements IUpgradeable {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private final UpgradeChipItem.RestrictionTypes restrictionType;
    private final int basecapacity;
    private final int maxInvSize;
    private final int baseDamageReduction;
    private final float baseToughness;

    public UpgradeableArmorItem(String resname, ArmorItem.Type slot, int basecapacity, int maxInvSize, int baseDamageReduction, float baseToughness, UpgradeChipItem.RestrictionTypes restrictionType) {
        super(resname, CustomArmorMaterial.UNNECESSARY, slot, new Item.Properties());
        ModCreativeTabs.putItem(ModCreativeTabs.TOOLS_AND_ARMOR, () -> this);
        this.basecapacity = basecapacity;
        this.maxInvSize = maxInvSize;
        this.baseDamageReduction = baseDamageReduction;
        this.baseToughness = baseToughness;
        this.restrictionType = restrictionType;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new InventoryEnergyProvider(this.basecapacity, this.maxInvSize);
    }

    public static int getEnergyCost(ItemStack stack) {
        return 20 + NBTHelper.getInt(stack, "energycost", 0);
    }

    public boolean m_142522_(ItemStack stack) {
        return this.m_142158_(stack) < 13;
    }

    @Deprecated
    public int m_142158_(ItemStack stack) {
        return PTClientUtil.getBarWidthForEnergyItem(stack);
    }

    public int m_142159_(ItemStack p_150901_) {
        return PlantTechConstants.DURABILITY_BAR_COLOUR;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_()) {
            if (!world.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                PTCommonUtil.openItemContainer(sp, "container.upgradeableitem", stack, ItemUpgradeableMenu::new);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    @Override
    public void updateNBTValues(ItemStack stack) {
        AtomicInteger increaseCapacity = new AtomicInteger();
        PTCommonUtil.tryAccessInv((ICapabilityProvider)stack, inv -> {
            int energyCost = 0;
            int energyProduction = 0;
            int increaseArmor = 0;
            float increaseToughness = 0.0f;
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stackInSlot = inv.getStackInSlot(i);
                Item patt4562$temp = stackInSlot.m_41720_();
                if (!(patt4562$temp instanceof UpgradeChipItem)) continue;
                UpgradeChipItem item = (UpgradeChipItem)patt4562$temp;
                energyCost += item.getEnergyCost();
                increaseCapacity.addAndGet(item.getIncreaseCapacity());
                energyProduction += item.getEnergyProduction();
                increaseArmor += item.getIncreaseArmor();
                increaseToughness += item.getIncreaseToughness();
                Enchantment ench = item.getEnchantment();
                if (!item.isAllowed(this.f_265916_.m_266308_().m_20749_()) || ench == null) continue;
                if (enchantments.containsKey(ench)) {
                    int nextlevel = (Integer)enchantments.get(ench) + 1;
                    enchantments.put(ench, nextlevel);
                    continue;
                }
                enchantments.put(ench, 1);
            }
            stack.m_41785_().clear();
            for (Enchantment ench : enchantments.keySet()) {
                int level = (Integer)enchantments.get(ench);
                stack.m_41663_(ench, Math.min(ench.m_6586_(), level));
            }
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128405_("energycost", energyCost);
            nbt.m_128405_("energyproduction", energyProduction);
            nbt.m_128405_("increasearmor", increaseArmor);
            nbt.m_128350_("increasetoughness", increaseToughness);
        });
        PTCommonUtil.tryAccessEnergyStorage((ICapabilityProvider)stack, storage -> storage.setEnergyMaxStored(this.basecapacity + increaseCapacity.get()));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == this.f_265916_.m_266308_()) {
            multimap.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.m_20749_()], "Armor modifier", (double)this.getDamageReduceAmount(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.m_20749_()], "Armor toughness", (double)this.getToughness(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public int getDamageReduceAmount(ItemStack stack) {
        return this.baseDamageReduction + NBTHelper.getInt(stack, "increasearmor", 0);
    }

    public float getToughness(ItemStack stack) {
        return this.baseToughness + NBTHelper.getFloat(stack, "increasetoughness", 0);
    }

    public boolean m_41465_() {
        return false;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.f_46443_ && !stack.m_41619_() && world.m_46467_() % 200L == 0L) {
            PTCommonUtil.tryAccessEnergy((ICapabilityProvider)stack, cap -> cap.receiveEnergy(NBTHelper.getInt(stack, "energyproduction", 0), false));
        }
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        PTClientUtil.appendEnergyTooltip(stack, tooltip);
        tooltip.add((Component)Component.m_237110_((String)"planttech2.info.energycosts", (Object[])new Object[]{UpgradeableArmorItem.getEnergyCost(stack)}));
        tooltip.add((Component)Component.m_237115_((String)"planttech2.info.openwithshift"));
    }
}

