/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import java.util.Arrays;
import java.util.List;
import net.kaneka.planttech2.configuration.PlantTech2Configuration;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class UpgradeChipItem
extends Item {
    private final int energyCost;
    private final int increaseCapacity;
    private final int energyProduction;
    private final int increaseHarvestlevel;
    private final int increaseArmor;
    private final float increaseAttack;
    private final float increaseAttackSpeed;
    private final float increaseBreakdownRate;
    private final float increaseToughness;
    private final boolean unlockShovelFeat;
    private final boolean unlockAxeFeat;
    private final boolean unlockHoeFeat;
    private final boolean unlockShearFeat;
    private final Enchantment enchantment;
    private final List<RestrictionTypes> restrictions;

    public UpgradeChipItem(Properties properties) {
        super(new Item.Properties());
        ModCreativeTabs.putItem(ModCreativeTabs.CHIPS, () -> this);
        this.energyCost = properties.energyCost;
        this.increaseCapacity = properties.increaseCapacity;
        this.energyProduction = properties.energyProduction;
        this.increaseHarvestlevel = properties.increaseHarvestlevel;
        this.increaseArmor = properties.increaseArmor;
        this.increaseAttack = properties.increaseAttack;
        this.increaseAttackSpeed = properties.increaseAttackSpeed;
        this.increaseBreakdownRate = properties.increaseBreakdownRate;
        this.increaseToughness = properties.increaseToughness;
        this.unlockShovelFeat = properties.unlockShovelFeat;
        this.unlockAxeFeat = properties.unlockAxeFeat;
        this.unlockHoeFeat = properties.unlockHoeFeat;
        this.unlockShearFeat = properties.unlockShearFeat;
        this.enchantment = properties.enchantment;
        this.restrictions = properties.restrictions;
    }

    public int getEnergyCost() {
        return (int)((double)this.energyCost * (Double)PlantTech2Configuration.MULTIPLIER_ENERGYCOSTS.get());
    }

    public int getIncreaseCapacity() {
        return (int)((double)this.increaseCapacity * (Double)PlantTech2Configuration.MULTIPLIER_CAPACITY.get());
    }

    public static int getCapacityMax() {
        return (int)(50000.0 * (Double)PlantTech2Configuration.MULTIPLIER_CAPACITY_MAX.get());
    }

    public int getEnergyProduction() {
        return (int)((double)this.energyProduction * (Double)PlantTech2Configuration.MULTIPLIER_ENERGYPRODUCTION.get());
    }

    public int getIncreaseHarvestlevel() {
        return this.increaseHarvestlevel;
    }

    public float getIncreaseAttack() {
        return (float)((double)this.increaseAttack * (Double)PlantTech2Configuration.MULTIPLIER_ATTACK.get());
    }

    public static float getAttackMax() {
        return (float)(20.0 * (Double)PlantTech2Configuration.MULTIPLIER_ATTACK_MAX.get());
    }

    public float getIncreaseAttackSpeed() {
        return (float)((double)this.increaseAttackSpeed * (Double)PlantTech2Configuration.MULTIPLIER_ATTACKSPEED.get());
    }

    public static float getAttackSpeedMax() {
        return (float)(2.0 * (Double)PlantTech2Configuration.MULTIPLIER_ATTACKSPEED_MAX.get());
    }

    public float getIncreaseBreakdownRate() {
        return (float)((double)this.increaseBreakdownRate * (Double)PlantTech2Configuration.MULTIPLIER_BREAKDOWNRATE.get());
    }

    public static float getBreakdownRateMax() {
        return (float)(10.0 * (Double)PlantTech2Configuration.MULTIPLIER_BREAKDOWNRATE_MAX.get());
    }

    public int getIncreaseArmor() {
        return (int)((double)this.increaseArmor * (Double)PlantTech2Configuration.MULTIPLIER_ARMOR.get());
    }

    public float getIncreaseToughness() {
        return (float)((double)this.increaseToughness * (Double)PlantTech2Configuration.MULTIPLIER_THOUGHNESS.get());
    }

    public static float getToughnessMax() {
        return (float)(6.0 * (Double)PlantTech2Configuration.MULTIPLIER_THOUGHNESS_MAX.get());
    }

    public boolean isUnlockShovelFeat() {
        return this.unlockShovelFeat;
    }

    public boolean isUnlockAxeFeat() {
        return this.unlockAxeFeat;
    }

    public boolean isUnlockHoeFeat() {
        return this.unlockHoeFeat;
    }

    public boolean isUnlockShearsFeat() {
        return this.unlockShearFeat;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public boolean isAllowed(int index) {
        return this.restrictions.contains((Object)RestrictionTypes.values()[index]);
    }

    public boolean isAllowed(RestrictionTypes type) {
        return this.restrictions.contains((Object)type);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.increaseCapacity > 0) {
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.increasecapacity", (Object[])new Object[]{this.getIncreaseCapacity()}));
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.increasecapacitymax", (Object[])new Object[]{UpgradeChipItem.getCapacityMax()}));
        }
        if (this.energyProduction > 0) {
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.energyproduction", (Object[])new Object[]{this.getEnergyProduction()}));
        }
        if (this.increaseHarvestlevel > 0) {
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.increaseharvestlevel", (Object[])new Object[]{this.getIncreaseHarvestlevel()}));
        }
        if (this.increaseArmor > 0) {
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.increasearmor", (Object[])new Object[]{this.getIncreaseArmor()}));
        }
        if (this.increaseAttack > 0.0f) {
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.increaseattack", (Object[])new Object[]{Float.valueOf(this.getIncreaseAttack())}));
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.increaseattackmax", (Object[])new Object[]{Float.valueOf(UpgradeChipItem.getAttackMax())}));
        }
        if (this.increaseAttackSpeed > 0.0f) {
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.increaseattackspeed", (Object[])new Object[]{Float.valueOf(this.getIncreaseAttackSpeed())}));
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.increaseattackspeedmax", (Object[])new Object[]{Float.valueOf(UpgradeChipItem.getAttackSpeedMax())}));
        }
        if (this.increaseBreakdownRate > 0.0f) {
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.increasebreakdownrate", (Object[])new Object[]{Float.valueOf(this.getIncreaseBreakdownRate())}));
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.increasebreakdownratemax", (Object[])new Object[]{Float.valueOf(UpgradeChipItem.getBreakdownRateMax())}));
        }
        if (this.increaseToughness > 0.0f) {
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.increasetougness", (Object[])new Object[]{Float.valueOf(this.getIncreaseToughness())}));
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.increasetougnessmax", (Object[])new Object[]{Float.valueOf(UpgradeChipItem.getToughnessMax())}));
        }
        if (this.unlockAxeFeat) {
            tooltip.add((Component)Component.m_237115_((String)"planttech2.info.upgradechip.unlockaxefeat"));
        }
        if (this.unlockShovelFeat) {
            tooltip.add((Component)Component.m_237115_((String)"planttech2.info.upgradechip.unlockshovelfeat"));
        }
        if (this.unlockShearFeat) {
            tooltip.add((Component)Component.m_237115_((String)"planttech2.info.upgradechip.unlockshearsfeat"));
        }
        if (this.unlockHoeFeat) {
            tooltip.add((Component)Component.m_237115_((String)"planttech2.info.upgradechip.unlockhoefeat"));
        }
        if (this.enchantment != null) {
            tooltip.add((Component)Component.m_237115_((String)"planttech2.info.upgradechip.add").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)this.enchantment.m_44704_())));
            tooltip.add((Component)Component.m_237115_((String)"planttech2.info.upgradechip.stackable"));
        }
        if (this.energyCost > 0) {
            tooltip.add((Component)Component.m_237110_((String)"planttech2.info.upgradechip.energycosts", (Object[])new Object[]{this.getEnergyCost()}));
        }
    }

    public static class Properties {
        private int energyCost = 0;
        private int increaseCapacity = 0;
        private int energyProduction = 0;
        private int increaseHarvestlevel = 0;
        private int increaseArmor = 0;
        private float increaseAttack = 0.0f;
        private float increaseAttackSpeed = 0.0f;
        private float increaseBreakdownRate = 0.0f;
        private float increaseToughness = 0.0f;
        private boolean unlockShovelFeat = false;
        private boolean unlockAxeFeat = false;
        private boolean unlockHoeFeat = false;
        private boolean unlockShearFeat = false;
        private Enchantment enchantment;
        private final List<RestrictionTypes> restrictions;

        public Properties(RestrictionTypes ... restrictions) {
            this.restrictions = Arrays.stream(restrictions).toList();
        }

        public static Properties of(RestrictionTypes ... restrictions) {
            return new Properties(restrictions);
        }

        public Properties setEnergyCost(int energyCost) {
            this.energyCost = energyCost;
            return this;
        }

        public Properties setIncreaseCapacity(int increaseCapacity) {
            this.increaseCapacity = increaseCapacity;
            return this;
        }

        public Properties setEnergyProduction(int energyProduction) {
            this.energyProduction = energyProduction;
            return this;
        }

        public Properties setIncreaseHarvestlevel(int increaseHarvestlevel) {
            this.increaseHarvestlevel = increaseHarvestlevel;
            return this;
        }

        public Properties setIncreaseAttack(float increaseAttack) {
            this.increaseAttack = increaseAttack;
            return this;
        }

        public Properties setIncreaseAttackSpeed(float increaseAttackSpeed) {
            this.increaseAttackSpeed = increaseAttackSpeed;
            return this;
        }

        public Properties setIncreaseBreakdownRate(float increaseBreakdownRate) {
            this.increaseBreakdownRate = increaseBreakdownRate;
            return this;
        }

        public Properties setIncreaseArmor(int increaseArmor) {
            this.increaseArmor = increaseArmor;
            return this;
        }

        public Properties setIncreaseToughness(float increaseToughness) {
            this.increaseToughness = increaseToughness;
            return this;
        }

        public Properties setUnlockShovelFeat() {
            this.unlockShovelFeat = true;
            return this;
        }

        public Properties setUnlockAxeFeat() {
            this.unlockAxeFeat = true;
            return this;
        }

        public Properties setUnlockHoeFeat() {
            this.unlockHoeFeat = true;
            return this;
        }

        public Properties setUnlockShearsFeat() {
            this.unlockShearFeat = true;
            return this;
        }

        public Properties setEnchantment(Enchantment ench) {
            this.enchantment = ench;
            return this;
        }
    }

    public static enum RestrictionTypes {
        HELMET,
        CHEST,
        LEGGINGS,
        BOOTS,
        RANGED_WEAPON,
        MELEE_WEAPON,
        TOOL;

    }
}

