/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import net.kaneka.planttech2.inventory.ItemUpgradeableMenu;
import net.kaneka.planttech2.items.upgradeable.BaseUpgradeableItem;
import net.kaneka.planttech2.items.upgradeable.UpgradeChipItem;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;

public class RangedWeaponItem
extends BaseUpgradeableItem {
    public RangedWeaponItem(Item.Properties property, int basecapacity, int maxInvSize) {
        super(property, basecapacity, maxInvSize, 0.0f, 2.4f, UpgradeChipItem.RestrictionTypes.RANGED_WEAPON);
    }

    protected ItemStack findAmmo(Player player) {
        if (this.isArrow(player.m_21120_(InteractionHand.OFF_HAND))) {
            return player.m_21120_(InteractionHand.OFF_HAND);
        }
        if (this.isArrow(player.m_21120_(InteractionHand.MAIN_HAND))) {
            return player.m_21120_(InteractionHand.MAIN_HAND);
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = player.m_150109_().m_8020_(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    protected boolean isArrow(ItemStack stack) {
        return stack.m_41720_() instanceof ArrowItem;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            boolean flag = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
            ItemStack itemstack = this.findAmmo(player);
            int i = this.m_8105_(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)i, (!itemstack.m_41619_() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.m_41619_() || flag) {
                float f;
                if (itemstack.m_41619_()) {
                    itemstack = new ItemStack((ItemLike)Items.f_42412_);
                }
                if (!((double)(f = RangedWeaponItem.getArrowVelocity(i)) < 0.1)) {
                    boolean flag1 = player.m_150110_().f_35937_ || itemstack.m_41720_() instanceof ArrowItem && ((ArrowItem)itemstack.m_41720_()).isInfinite(itemstack, stack, player);
                    int cost = RangedWeaponItem.getEnergyCost(stack);
                    if (!level.f_46443_ && PTCommonUtil.tryAccessEnergyValue((ICapabilityProvider)stack, cap -> Float.valueOf(cap.getEnergyStored()), Float.valueOf(0.0f)).floatValue() > (float)cost) {
                        int k;
                        int j;
                        ArrowItem itemarrow = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
                        AbstractArrow entityarrow = itemarrow.m_6394_(level, itemstack, (LivingEntity)player);
                        entityarrow = this.customizeArrow(entityarrow);
                        entityarrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * 3.0f, 1.0f);
                        if (f == 1.0f) {
                            entityarrow.m_36762_(true);
                        }
                        if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack)) > 0) {
                            entityarrow.m_36781_(entityarrow.m_36789_() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                            entityarrow.m_36735_(k);
                        }
                        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                            entityarrow.m_20254_(100);
                        }
                        if (flag1 || player.m_150110_().f_35937_ && (itemstack.m_41720_() == Items.f_42737_ || itemstack.m_41720_() == Items.f_42738_)) {
                            entityarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.m_7967_((Entity)entityarrow);
                        if (!player.m_7500_()) {
                            PTCommonUtil.tryAccessEnergy((ICapabilityProvider)stack, cap -> cap.extractEnergy(cost, false));
                        }
                    }
                    RandomSource rand = level.f_46441_;
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (rand.m_188501_() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            player.m_150109_().m_36057_(itemstack);
                        }
                    }
                }
            }
        }
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.BOW;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6047_()) {
            if (PTCommonUtil.tryAccessEnergyValue((ICapabilityProvider)stack, cap -> Float.valueOf(cap.getEnergyStored()), Float.valueOf(0.0f)).floatValue() >= (float)RangedWeaponItem.getEnergyCost(stack)) {
                boolean flag = !this.findAmmo(player).m_41619_();
                InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)flag);
                if (ret != null) {
                    return ret;
                }
                if (!player.m_150110_().f_35937_ && !flag) {
                    return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
                }
                player.m_6672_(hand);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        } else if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PTCommonUtil.openItemContainer(sp, "container.upgradeableitem", stack, ItemUpgradeableMenu::new);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public AbstractArrow customizeArrow(AbstractArrow arrow) {
        return arrow;
    }
}

