/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import java.util.List;
import net.kaneka.planttech2.items.upgradeable.BaseUpgradeableItem;
import net.kaneka.planttech2.items.upgradeable.UpgradeChipItem;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.kaneka.planttech2.utilities.NBTHelper;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MultitoolItem
extends BaseUpgradeableItem {
    public MultitoolItem() {
        super(new Item.Properties(), 10000, 10, 2.0f, 2.4f, UpgradeChipItem.RestrictionTypes.TOOL);
        ModCreativeTabs.putItem(ModCreativeTabs.TOOLS_AND_ARMOR, () -> this);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (PTCommonUtil.tryAccessEnergyValue((ICapabilityProvider)stack, cap -> Float.valueOf(cap.getEnergyStored()), Float.valueOf(0.0f)).floatValue() >= (float)MultitoolItem.getEnergyCost(stack)) {
            if (state.m_204336_(BlockTags.f_144280_) || state.m_204336_(BlockTags.f_144282_) || state.m_204336_(BlockTags.f_144283_)) {
                int i = this.getHarvestLevel(stack);
                Tiers tier = Tiers.WOOD;
                if (i == 1) {
                    tier = Tiers.STONE;
                }
                if (i == 2) {
                    tier = Tiers.IRON;
                }
                if (i == 3) {
                    tier = Tiers.GOLD;
                }
                if (i == 4) {
                    tier = Tiers.DIAMOND;
                }
                if (i >= 5) {
                    tier = Tiers.NETHERITE;
                }
                return TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)state);
            }
            return state.m_60734_() == Blocks.f_50033_;
        }
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (PTCommonUtil.tryAccessEnergyValue((ICapabilityProvider)stack, cap -> Float.valueOf(cap.getEnergyStored()), Float.valueOf(0.0f)).floatValue() >= (float)MultitoolItem.getEnergyCost(stack)) {
            if (state.m_204336_(BlockTags.f_144280_) || state.m_204336_(BlockTags.f_144282_) || state.m_204336_(BlockTags.f_144283_)) {
                return this.getEfficiency(stack);
            }
            if (state.m_60734_() == Blocks.f_50033_) {
                return 15.0f;
            }
        }
        return super.m_8102_(stack, state);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack stack = ctx.m_43722_();
        if (PTCommonUtil.tryAccessEnergyValue((ICapabilityProvider)stack, cap -> Float.valueOf(cap.getEnergyStored()), Float.valueOf(0.0f)).floatValue() >= (float)MultitoolItem.getEnergyCost(stack)) {
            Level level = ctx.m_43725_();
            BlockPos blockpos = ctx.m_8083_();
            BlockState state = level.m_8055_(blockpos);
            BlockState state_for_spade = ShovelItem.getShovelPathingState((BlockState)state);
            BlockState state_for_hoe = level.m_8055_(blockpos).getToolModifiedState(ctx, ToolActions.HOE_TILL, false);
            BlockState block_for_strinping = level.m_8055_(blockpos).getToolModifiedState(ctx, ToolActions.AXE_STRIP, false);
            Player PlayerEntity = ctx.m_43723_();
            if (ctx.m_43719_() != Direction.DOWN && level.m_8055_(blockpos.m_7494_()).m_60795_() && state_for_spade != null) {
                if (NBTHelper.getBoolean(ctx.m_43722_(), "unlockshovel", false)) {
                    level.m_5594_(PlayerEntity, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!level.f_46443_) {
                        level.m_7731_(blockpos, state_for_spade, 11);
                        if (PlayerEntity != null && !PlayerEntity.m_7500_()) {
                            PTCommonUtil.tryAccessEnergy((ICapabilityProvider)stack, cap -> cap.extractEnergy(MultitoolItem.getEnergyCost(stack), false));
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (block_for_strinping != null) {
                if (NBTHelper.getBoolean(ctx.m_43722_(), "unlockaxe", false)) {
                    level.m_5594_(PlayerEntity, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!level.f_46443_) {
                        level.m_7731_(blockpos, (BlockState)block_for_strinping.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))), 11);
                        if (PlayerEntity != null && !PlayerEntity.m_7500_()) {
                            PTCommonUtil.tryAccessEnergy((ICapabilityProvider)stack, cap -> cap.extractEnergy(MultitoolItem.getEnergyCost(stack), false));
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (ctx.m_43719_() != Direction.DOWN && level.m_46859_(blockpos.m_7494_()) && state_for_hoe != null && NBTHelper.getBoolean(ctx.m_43722_(), "unlockhoe", false)) {
                level.m_5594_(PlayerEntity, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.f_46443_) {
                    level.m_7731_(blockpos, state_for_hoe, 11);
                    if (PlayerEntity != null && !PlayerEntity.m_7500_()) {
                        PTCommonUtil.tryAccessEnergy((ICapabilityProvider)stack, cap -> cap.extractEnergy(MultitoolItem.getEnergyCost(stack), false));
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public int getHarvestLevel(ItemStack stack) {
        return NBTHelper.getInt(stack, "harvestlevel", 0);
    }

    public float getEfficiency(ItemStack stack) {
        return Math.min(NBTHelper.getFloat(stack, "breakdownrate", 4), UpgradeChipItem.getBreakdownRateMax());
    }

    @Override
    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return super.m_6813_(stack, level, state, pos, entityLiving);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity.m_9236_().f_46443_) {
            return InteractionResult.PASS;
        }
        if (entity instanceof IForgeShearable) {
            IForgeShearable fs = (IForgeShearable)entity;
            BlockPos pos = entity.m_20183_();
            if (fs.isShearable(stack, entity.m_9236_(), pos)) {
                List drops = fs.onSheared(player, stack, entity.m_9236_(), pos, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack));
                RandomSource rand = player.m_9236_().f_46441_;
                drops.forEach(d -> {
                    ItemEntity ent = entity.m_5552_(d, 1.0f);
                    if (ent != null) {
                        ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.m_188501_() - rand.m_188501_()) * 0.1f), (double)(rand.m_188501_() * 0.05f), (double)((rand.m_188501_() - rand.m_188501_()) * 0.1f)));
                    }
                });
                stack.m_41622_(1, entity, e -> e.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

