/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryEnergyProvider
implements ICapabilitySerializable<CompoundTag> {
    protected final BioEnergyStorage energystorage;
    private final LazyOptional<IEnergyStorage> energyCap;
    protected final ItemStackHandler itemhandler;
    private final LazyOptional<IItemHandler> inventoryCap;

    public InventoryEnergyProvider(int storage, int invSize) {
        this.energystorage = new BioEnergyStorage(storage);
        this.energystorage.setEnergyStored(storage);
        this.energyCap = LazyOptional.of(() -> this.energystorage);
        this.itemhandler = new ItemStackHandler(invSize);
        this.inventoryCap = LazyOptional.of(() -> this.itemhandler);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("inventory", (Tag)this.itemhandler.serializeNBT());
        compound.m_128365_("energy", (Tag)this.energystorage.serializeNBT());
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.itemhandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.energystorage.deserializeNBT(nbt.m_128469_("energy"));
    }
}

