/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.kaneka.planttech2.inventory.ItemUpgradeableMenu;
import net.kaneka.planttech2.items.upgradeable.IUpgradeable;
import net.kaneka.planttech2.items.upgradeable.InventoryEnergyProvider;
import net.kaneka.planttech2.items.upgradeable.UpgradeChipItem;
import net.kaneka.planttech2.utilities.NBTHelper;
import net.kaneka.planttech2.utilities.PTClientUtil;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.kaneka.planttech2.utilities.PlantTechConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class BaseUpgradeableItem
extends Item
implements IUpgradeable {
    private final UpgradeChipItem.RestrictionTypes restrictionType;
    private final int basecapacity;
    private final int maxInvSize;
    private final float baseAttack;
    private final float baseAttackSpeed;

    public BaseUpgradeableItem(Item.Properties property, int basecapacity, int maxInvSize, float baseAttack, float baseAttackSpeed, UpgradeChipItem.RestrictionTypes restrictionType) {
        super(property.m_41487_(1));
        this.basecapacity = basecapacity;
        this.maxInvSize = maxInvSize;
        this.baseAttack = baseAttack;
        this.baseAttackSpeed = baseAttackSpeed;
        this.restrictionType = restrictionType;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new InventoryEnergyProvider(this.basecapacity, this.maxInvSize);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag compound = super.getShareTag(stack);
        if (compound != null) {
            PTCommonUtil.writeEnergySharedTag((ICapabilityProvider)stack, compound);
        }
        return compound;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null) {
            PTCommonUtil.readEnergySharedTag((ICapabilityProvider)stack, nbt);
        }
        super.readShareTag(stack, nbt);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!((Player)attacker).m_150110_().f_35937_) {
            PTCommonUtil.tryAccessEnergy((ICapabilityProvider)stack, cap -> cap.extractEnergy(BaseUpgradeableItem.getEnergyCost(stack), false));
        }
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!level.f_46443_ && state.m_60800_((BlockGetter)level, pos) != 0.0f && !((Player)entityLiving).m_150110_().f_35937_) {
            PTCommonUtil.tryAccessEnergy((ICapabilityProvider)stack, cap -> cap.extractEnergy(BaseUpgradeableItem.getEnergyCost(stack), false));
        }
        return true;
    }

    protected static int getEnergyCost(ItemStack stack) {
        return 20 + NBTHelper.getInt(stack, "energycost", 0);
    }

    private double getAttackSpeed(ItemStack stack) {
        return Math.min((double)(this.baseAttackSpeed + NBTHelper.getFloat(stack, "attackspeed", 0)), -0.4);
    }

    private double getAttackDamage(ItemStack stack) {
        return Math.min(this.baseAttack + NBTHelper.getFloat(stack, "attack", 0), UpgradeChipItem.getAttackMax());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        PTClientUtil.appendEnergyTooltip(stack, tooltip);
        tooltip.add((Component)Component.m_237110_((String)"planttech2.info.energycosts", (Object[])new Object[]{BaseUpgradeableItem.getEnergyCost(stack)}));
        tooltip.add((Component)Component.m_237115_((String)"planttech2.info.openwithshift"));
    }

    public boolean m_142522_(ItemStack stack) {
        return this.m_142158_(stack) < 13;
    }

    @Deprecated
    public int m_142158_(ItemStack stack) {
        return PTClientUtil.getBarWidthForEnergyItem(stack);
    }

    public int m_142159_(ItemStack stack) {
        return PlantTechConstants.DURABILITY_BAR_COLOUR;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_()) {
            if (!world.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                PTCommonUtil.openItemContainer(sp, "container.upgradeableitem", stack, ItemUpgradeableMenu::new);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    @Override
    public void updateNBTValues(ItemStack stack) {
        AtomicInteger increaseCapacity = new AtomicInteger();
        PTCommonUtil.tryAccessInv((ICapabilityProvider)stack, inv -> {
            int energyCost = 0;
            int energyProduction = 0;
            int increaseHarvestlevel = 0;
            float increaseAttack = 0.0f;
            float increaseAttackSpeed = 0.0f;
            float increaseBreakdownRate = 0.0f;
            boolean unlockShovelFeat = false;
            boolean unlockAxeFeat = false;
            boolean unlockHoeFeat = false;
            boolean unlockShearsFeat = false;
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            for (int i = 0; i < inv.getSlots(); ++i) {
                Item patt6622$temp;
                ItemStack stackInSlot = inv.getStackInSlot(i);
                if (stackInSlot.m_41619_() || !((patt6622$temp = stackInSlot.m_41720_()) instanceof UpgradeChipItem)) continue;
                UpgradeChipItem item = (UpgradeChipItem)patt6622$temp;
                energyCost += item.getEnergyCost();
                increaseCapacity.addAndGet(item.getIncreaseCapacity());
                energyProduction += item.getEnergyProduction();
                increaseHarvestlevel += item.getIncreaseHarvestlevel();
                increaseAttack += item.getIncreaseAttack();
                increaseAttackSpeed += item.getIncreaseAttackSpeed();
                increaseBreakdownRate += item.getIncreaseBreakdownRate();
                if (item.isUnlockShovelFeat()) {
                    unlockShovelFeat = true;
                }
                if (item.isUnlockAxeFeat()) {
                    unlockAxeFeat = true;
                }
                if (item.isUnlockHoeFeat()) {
                    unlockHoeFeat = true;
                }
                if (item.isUnlockShearsFeat()) {
                    unlockShearsFeat = true;
                }
                Enchantment ench = item.getEnchantment();
                if (!item.isAllowed(this.restrictionType) || ench == null) continue;
                if (enchantments.containsKey(ench)) {
                    int nextlevel = (Integer)enchantments.get(ench) + 1;
                    enchantments.put(ench, nextlevel);
                    continue;
                }
                enchantments.put(ench, 1);
            }
            stack.m_41785_().clear();
            for (Enchantment ench : enchantments.keySet()) {
                int level = (Integer)enchantments.get(ench);
                stack.m_41663_(ench, Math.min(ench.m_6586_(), level));
            }
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128405_("energycost", energyCost);
            nbt.m_128405_("energyproduction", energyProduction);
            nbt.m_128405_("harvestlevel", increaseHarvestlevel);
            nbt.m_128350_("attack", increaseAttack);
            nbt.m_128350_("attackspeed", increaseAttackSpeed);
            nbt.m_128350_("breakdownrate", 0.5f + increaseBreakdownRate);
            nbt.m_128379_("unlockshovel", unlockShovelFeat);
            nbt.m_128379_("unlockaxe", unlockAxeFeat);
            nbt.m_128379_("unlockhoe", unlockHoeFeat);
            nbt.m_128379_("unlockshears", unlockShearsFeat);
        });
        PTCommonUtil.tryAccessEnergyStorage((ICapabilityProvider)stack, storage -> storage.setEnergyMaxStored(this.basecapacity + increaseCapacity.get()));
    }

    public void m_6883_(ItemStack stack, Level world, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!world.f_46443_ && !stack.m_41619_() && world.m_46467_() % 200L == 0L) {
            PTCommonUtil.tryAccessEnergy((ICapabilityProvider)stack, cap -> cap.receiveEnergy(NBTHelper.getInt(stack, "energyproduction", 0), false));
        }
    }
}

