/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import javax.annotation.Nullable;
import net.kaneka.planttech2.energy.BioEnergyProvider;
import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.kaneka.planttech2.utilities.PTClientUtil;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.kaneka.planttech2.utilities.PlantTechConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class EnergyStorageItem
extends Item {
    private final int capacity;

    public EnergyStorageItem(Item.Properties property, int capacity) {
        super(property.m_41503_(capacity));
        this.capacity = capacity;
        ModCreativeTabs.putItemStack(ModCreativeTabs.MAIN, () -> {
            ItemStack full = new ItemStack((ItemLike)this);
            PTCommonUtil.tryAccessEnergyStorage((ICapabilityProvider)full, BioEnergyStorage::max);
            return full;
        });
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new BioEnergyProvider(this.capacity);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag compound = super.getShareTag(stack);
        if (compound != null) {
            PTCommonUtil.writeEnergySharedTag((ICapabilityProvider)stack, compound);
        }
        return compound;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null) {
            PTCommonUtil.readEnergySharedTag((ICapabilityProvider)stack, nbt);
        }
        super.readShareTag(stack, nbt);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        PTCommonUtil.tryAccessEnergy((ICapabilityProvider)stack, storage -> tooltip.add((Component)Component.m_237113_((String)(storage.getEnergyStored() + "/" + storage.getMaxEnergyStored() + "BE"))));
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    @Deprecated
    public int m_142158_(ItemStack stack) {
        return PTClientUtil.getBarWidthForEnergyItem(stack);
    }

    public int m_142159_(ItemStack stack) {
        return PlantTechConstants.DURABILITY_BAR_COLOUR;
    }
}

