/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.CropBarsBlock;
import net.kaneka.planttech2.blocks.CropBaseBlock;
import net.kaneka.planttech2.blocks.entity.CropsBlockEntity;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.crops.TemperatureTolerance;
import net.kaneka.planttech2.enums.CropTraitsTypes;
import net.kaneka.planttech2.hashmaps.TraitsManager;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CropSeedItem
extends Item {
    private final CropTypes cropType;

    public CropSeedItem(CropTypes cropType) {
        super(new Item.Properties());
        ModCreativeTabs.putItemStack(ModCreativeTabs.SEEDS, () -> {
            TraitsManager.ItemImpl t = TraitsManager.ItemImpl.of(new ItemStack((ItemLike)this));
            t.type = cropType;
            t.analysed = true;
            t.save();
            return t.stack;
        });
        this.cropType = cropType;
        ComposterBlock.f_51914_.put((Object)this, 0.3f);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                ServerLevel level = source.m_7727_();
                BlockPos target = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                this.m_123573_(CropSeedItem.plant((Level)level, target, stack));
                if (!level.m_5776_() && this.m_123570_()) {
                    level.m_46796_(2005, target, 0);
                }
                return stack;
            }
        });
    }

    public CropTypes getCropType() {
        return this.cropType;
    }

    public static void addTip(List<Component> tooltip, TraitsManager.ItemImpl manager, String key, CropTraitsTypes trait) {
        CropSeedItem.addTip(tooltip, manager, key, trait, null);
    }

    public static List<Component> getTips(TraitsManager.ItemImpl manager) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        CropSeedItem.addTip(tooltip, manager, "planttech2.info.grow_speed", CropTraitsTypes.GROW_SPEED);
        CropSeedItem.addTip(tooltip, manager, "planttech2.info.sensitivity", CropTraitsTypes.SENSITIVITY);
        CropSeedItem.addTip(tooltip, manager, "planttech2.info.needed_light_level", CropTraitsTypes.LIGHT_SENSITIVITY, i -> 14 - i);
        CropSeedItem.addTip(tooltip, manager, "planttech2.info.water_range", CropTraitsTypes.WATER_SENSITIVITY, i -> i + 1);
        CropSeedItem.addTip(tooltip, manager, "planttech2.info.productivity", CropTraitsTypes.PRODUCTIVITY);
        CropSeedItem.addTip(tooltip, manager, "planttech2.info.fertility", CropTraitsTypes.FERTILITY);
        CropSeedItem.addTip(tooltip, manager, "planttech2.info.spreading_speed", CropTraitsTypes.SPREADING_SPEED);
        CropSeedItem.addTip(tooltip, manager, "planttech2.info.gene_strength", CropTraitsTypes.GENE_STRENGTH);
        CropSeedItem.addTip(tooltip, manager, "planttech2.info.energy_value", CropTraitsTypes.ENERGY_VALUE, i -> i * 20);
        return tooltip;
    }

    public static void addTip(List<Component> tooltip, TraitsManager.ItemImpl manager, String key, CropTraitsTypes trait, Function<Integer, Integer> func) {
        if (manager.hasTrait(trait)) {
            int level = manager.getTrait(trait);
            ChatFormatting colour = ChatFormatting.RESET;
            if (level == trait.getMin()) {
                colour = ChatFormatting.GRAY;
            }
            if (level == trait.getMax()) {
                colour = ChatFormatting.GREEN;
            }
            tooltip.add((Component)Component.m_237115_((String)key).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)String.valueOf(func == null ? level : func.apply(level))).m_130940_(colour)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        TraitsManager.ItemImpl manager = TraitsManager.ItemImpl.of(stack);
        tooltip.add((Component)Component.m_237115_((String)"planttech2.info.type").m_130946_(": ").m_7220_(this.cropType.getDisplayName()));
        if (manager.analysed) {
            tooltip.add((Component)Component.m_237115_((String)"planttech2.info.soil").m_130946_(": ").m_7220_(this.cropType.getDisplaySoilName()));
            tooltip.add((Component)Component.m_237115_((String)"planttech2.info.temperature").m_130946_(": ").m_7220_(CropSeedItem.temperatureString(this.cropType.getConfig().getTemperature(), manager.getTrait(CropTraitsTypes.TEMPERATURE_TOLERANCE))));
            tooltip.addAll(CropSeedItem.getTips(manager));
        } else {
            this.unknown(tooltip, "planttech2.info.soil");
            this.unknown(tooltip, "planttech2.info.temperature_tolerance");
            this.unknown(tooltip, "planttech2.info.grow_speed");
            this.unknown(tooltip, "planttech2.info.sensitivity");
            this.unknown(tooltip, "planttech2.info.needed_light_level");
            this.unknown(tooltip, "planttech2.info.water_range");
            this.unknown(tooltip, "planttech2.info.productivity");
            this.unknown(tooltip, "planttech2.info.fertility");
            this.unknown(tooltip, "planttech2.info.spreading_speed");
            this.unknown(tooltip, "planttech2.info.gene_strength");
            this.unknown(tooltip, "planttech2.info.energy_value");
        }
    }

    private void unknown(List<Component> tooltip, String key) {
        tooltip.add((Component)Component.m_237115_((String)key).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"planttech2.info.unknown").m_130940_(ChatFormatting.DARK_AQUA)));
    }

    public static Component temperatureString(TemperatureTolerance temp, int tolerance) {
        return Component.m_237113_((String)temp.getDisplayString(tolerance));
    }

    public static boolean plant(Level world, BlockPos pos, ItemStack stack) {
        CropTypes entry = CropTypes.getBySeed(stack).orElse(null);
        if (entry == null) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof CropBarsBlock) {
            world.m_46597_(pos, (BlockState)entry.getCropBlock().m_49966_().m_61124_((Property)CropBaseBlock.COPPER, (Comparable)((Boolean)state.m_61143_((Property)CropBaseBlock.COPPER))));
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CropsBlockEntity) {
                CropsBlockEntity crop = (CropsBlockEntity)blockEntity;
                TraitsManager.ItemImpl traits = TraitsManager.ItemImpl.of(stack);
                traits.analysed = true;
                traits.type = entry;
                crop.setTraits(traits);
                crop.setStartTick();
                return true;
            }
        }
        return false;
    }

    public static class ColorHandler
    implements ItemColor {
        public int m_92671_(ItemStack stack, int color) {
            return ((CropSeedItem)stack.m_41720_()).getCropType().getSeedColor();
        }
    }
}

