/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.blocks.entity.CropsBlockEntity;
import net.kaneka.planttech2.enums.CropTraitsTypes;
import net.kaneka.planttech2.hashmaps.TraitsManager;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.EnergyStorageItem;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class AdvancedAnalyserItem
extends EnergyStorageItem {
    public AdvancedAnalyserItem() {
        super(new Item.Properties().m_41487_(1), 1000);
        ModCreativeTabs.putItem(ModCreativeTabs.MAIN, () -> this);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockEntity blockEntity;
        ItemStack stack = ctx.m_43722_();
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Player player = ctx.m_43723_();
        if (!level.f_46443_ && player != null && (blockEntity = level.m_7702_(pos)) instanceof CropsBlockEntity) {
            CropsBlockEntity cbe = (CropsBlockEntity)blockEntity;
            if (cbe.isAnalysed()) {
                TraitsManager.TypedImpl traits = cbe.getTraits();
                this.sendTraits(player, traits);
            } else {
                PTCommonUtil.tryAccessEnergy((ICapabilityProvider)stack, cap -> {
                    if (cap.getEnergyStored() >= 100) {
                        cap.extractEnergy(100, false);
                        TraitsManager.TypedImpl traits = cbe.setAnalysedAndGetTraits();
                        this.sendTraits(player, traits);
                    } else {
                        player.m_213846_((Component)Component.m_237115_((String)"planttech2.tip.energy_item.no_energy"));
                    }
                });
            }
        }
        return super.m_6225_(ctx);
    }

    private void sendTraits(Player player, TraitsManager.TypedImpl traits) {
        player.m_213846_((Component)Component.m_237113_((String)"--------------------------------------"));
        this.msg(player, "planttech2.info.type", traits.type.getDisplayName().getString());
        this.msg(player, "planttech2.info.soil", traits.type.getDisplaySoilName().getString());
        this.msg(player, "planttech2.info.grow_speed", traits.getTrait(CropTraitsTypes.GROW_SPEED));
        this.msg(player, "planttech2.info.sensitivity", traits.getTrait(CropTraitsTypes.SENSITIVITY));
        this.msg(player, "planttech2.info.needed_light_level", String.valueOf(14 - traits.getTrait(CropTraitsTypes.LIGHT_SENSITIVITY)));
        this.msg(player, "planttech2.info.water_range", String.valueOf(1 + traits.getTrait(CropTraitsTypes.WATER_SENSITIVITY)));
        this.msg(player, "planttech2.info.temperature", CropSeedItem.temperatureString(traits.type.getConfig().getTemperature(), traits.getTrait(CropTraitsTypes.TEMPERATURE_TOLERANCE)).getString());
        this.msg(player, "planttech2.info.productivity", traits.getTrait(CropTraitsTypes.PRODUCTIVITY));
        this.msg(player, "planttech2.info.fertility", traits.getTrait(CropTraitsTypes.FERTILITY));
        this.msg(player, "planttech2.info.spreading_speed", traits.getTrait(CropTraitsTypes.SPREADING_SPEED));
        this.msg(player, "planttech2.info.gene_strength", traits.getTrait(CropTraitsTypes.GENE_STRENGTH));
        this.msg(player, "planttech2.info.energy_value", String.valueOf(traits.getTrait(CropTraitsTypes.ENERGY_VALUE) * 20));
    }

    private void msg(Player player, String key, int value) {
        this.msg(player, key, String.valueOf(value));
    }

    private void msg(Player player, String key, String value) {
        player.m_213846_((Component)Component.m_237115_((String)key).m_130946_(": " + value));
    }

    @Override
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"planttech2.tip.advanced_analyser"));
        tooltip.add((Component)Component.m_237110_((String)"planttech2.tip.energy_item.energy_use", (Object[])new Object[]{100}));
    }
}

