/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kaneka.planttech2.items.TierItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class PT2ItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    private final ItemStackHandler handler;
    private final Handler[] handlers;

    public PT2ItemStackHandler(ItemStackHandler handler, int size) {
        this(handler, size, (Handler handler2) -> {});
    }

    public PT2ItemStackHandler(ItemStackHandler handler, int from, int to) {
        this(handler, from, to, (Handler handler2) -> {});
    }

    public PT2ItemStackHandler(ItemStackHandler handler, int size, Consumer<Handler> extra) {
        this(handler, 0, size, extra);
    }

    public PT2ItemStackHandler(ItemStackHandler handler, final int from, final int to, final Consumer<Handler> extra) {
        this(handler, (List<Handler>)new ArrayList<Handler>(){
            {
                for (int i = from; i < to; ++i) {
                    Handler handler2 = Handler.of(i);
                    extra.accept(handler2);
                    this.add(handler2);
                }
            }
        });
    }

    public PT2ItemStackHandler(ItemStackHandler handler, List<Handler> handlers) {
        this.handler = handler;
        this.handlers = (Handler[])handlers.toArray(Handler[]::new);
    }

    public PT2ItemStackHandler(ItemStackHandler handler, Handler ... handlers) {
        this.handler = handler;
        this.handlers = handlers;
    }

    public boolean isEmpty() {
        return this.handlers.length == 0;
    }

    public CompoundTag serializeNBT() {
        throw new UnsupportedOperationException();
    }

    public void deserializeNBT(CompoundTag nbt) {
        throw new UnsupportedOperationException();
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.handler.setStackInSlot(this.getIndex(slot), stack);
    }

    public int getSlots() {
        return this.handlers.length;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.handler.getStackInSlot(this.getIndex(slot));
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        return this.handler.insertItem(this.getIndex(slot), stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.handler.extractItem(this.getIndex(slot), amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.getHandler((int)slot).maxCount;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.getHandler((int)slot).conditions.test(stack);
    }

    private int getIndex(int slot) {
        return this.getHandler((int)slot).index;
    }

    private Handler getHandler(int index) {
        return this.handlers[index];
    }

    public static class Handler {
        private final int index;
        private Predicate<ItemStack> conditions = stack -> true;
        private int maxCount = 64;

        private Handler(int index) {
            this.index = index;
        }

        public static Handler of(int index) {
            return new Handler(index);
        }

        public Handler setConditions(boolean enabled) {
            return this.setConditions((ItemStack stack) -> enabled);
        }

        public Handler setConditions(Item ... acceptableItems) {
            return this.setConditions((ItemStack stack) -> acceptableItems.length == 0 || Arrays.stream(acceptableItems).anyMatch(item -> stack.m_41720_() == item));
        }

        public Handler setConditions(Predicate<ItemStack> conditions) {
            this.conditions = conditions;
            return this;
        }

        public Handler setConditions(TierItem.ItemType type) {
            this.conditions = stack -> stack.m_41720_() instanceof TierItem && ((TierItem)stack.m_41720_()).getItemType() == type;
            return this.setMaxCount(1);
        }

        public Handler setMaxCount(int maxCount) {
            this.maxCount = maxCount;
            return this;
        }
    }
}

