/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.inventory;

import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyBlockEntity;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryFluidBlockEntity;
import net.kaneka.planttech2.inventory.BaseMenu;
import net.kaneka.planttech2.items.KnowledgeChip;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public abstract class BlockBaseMenu
extends BaseMenu {
    protected final EnergyInventoryBlockEntity blockEntity;
    protected final ContainerData data;

    public BlockBaseMenu(int id, MenuType<?> type, Inventory player, EnergyInventoryBlockEntity BlockEntity2, int slots) {
        super(id, type, player);
        this.blockEntity = BlockEntity2;
        this.data = BlockEntity2.getContainerData();
        this.m_38884_(this.data);
        this.prioritizedSlots = this.getSlotsPrioritized();
    }

    protected BaseMenu.LimitedItemInfoSlot createEnergyInSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return this.createEnergyInSlot(itemHandler, this.blockEntity.getEnergyInSlot(), xPosition, yPosition);
    }

    protected BaseMenu.LimitedItemInfoSlot createEnergyOutSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return this.createEnergyInSlot(itemHandler, this.blockEntity.getEnergyOutSlot(), xPosition, yPosition);
    }

    protected BaseMenu.LimitedItemInfoSlot createKnowledgeChipSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return new BaseMenu.LimitedItemInfoSlot(itemHandler, this.blockEntity.getKnowledgeChipSlot(), xPosition, yPosition, "slot.util.knowledgechip").setConditions(stack -> stack.m_41720_() instanceof KnowledgeChip);
    }

    protected BaseMenu.LimitedItemInfoSlot createFluidInSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return new BaseMenu.LimitedItemInfoSlot(itemHandler, ((EnergyInventoryFluidBlockEntity)this.blockEntity).getFluidInSlot(), xPosition, yPosition, "slot.util.fluidin").setConditions(stack -> PTCommonUtil.getBiomassCap((ICapabilityProvider)stack).getA().isPresent()).setLimited();
    }

    protected BaseMenu.LimitedItemInfoSlot createFluidOutSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return new BaseMenu.LimitedItemInfoSlot(itemHandler, ((EnergyInventoryFluidBlockEntity)this.blockEntity).getFluidOutSlot(), xPosition, yPosition, "slot.util.fluidout").setConditions(stack -> PTCommonUtil.getBiomassCap((ICapabilityProvider)stack).getA().isPresent()).setLimited();
    }

    public boolean m_6875_(Player playerIn) {
        return this.blockEntity.isUsableByPlayer(playerIn);
    }

    public EnergyBlockEntity getTE() {
        return this.blockEntity;
    }

    public int getValue(int id) {
        return this.data.m_6413_(id);
    }
}

