/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.inventory;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.kaneka.planttech2.addons.Pair;
import net.kaneka.planttech2.inventory.BlockBaseMenu;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class BaseMenu
extends AbstractContainerMenu {
    protected List<Pair<Integer, Integer>> prioritizedSlots;

    public BaseMenu(int id, MenuType<?> type, Inventory player) {
        super(type, id);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)player, x + y * 9 + 9, 23 + x * 18, 106 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)player, x, 23 + x * 18, 164));
        }
    }

    protected LimitedItemInfoSlot createSpeedUpgradeSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.speedupgrade").setConditions(TierItem.ItemType.SPEED_UPGRADE).setLimited();
    }

    protected LimitedItemInfoSlot createRangeUpgradeSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.rangeupgrade").setConditions(TierItem.ItemType.RANGE_UPGRADE).setLimited();
    }

    protected LimitedItemInfoSlot createEnergyInSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.energyin").setConditions(stack -> PTCommonUtil.getEnergyCap((ICapabilityProvider)stack).isPresent()).setLimited();
    }

    protected LimitedItemInfoSlot createEnergyOutSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.energyout").setConditions(stack -> PTCommonUtil.getEnergyCap((ICapabilityProvider)stack).isPresent()).setLimited();
    }

    protected LimitedItemInfoSlot createCapacityChipSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return (LimitedItemInfoSlot)new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.capacityupgrade").setConditions(TierItem.ItemType.CAPACITY_UPGRADE).setLimited().setShouldListen();
    }

    protected LimitedItemInfoSlot createFakeSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, String usage) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, usage).setConditions(false).setCanTake(false);
    }

    protected LimitedItemInfoSlot createOutoutSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.output").setConditions(false);
    }

    protected LimitedItemInfoSlot createDNAContainerSlot(IItemHandler handler, int index, int xPosition, int yPosition, String usage, boolean isEmpty) {
        return new LimitedItemInfoSlot(handler, index, xPosition, yPosition, usage).setConditions(stack -> isEmpty && stack.m_41720_() == ModItems.DNA_CONTAINER_EMPTY.get() || !isEmpty && stack.m_41720_() == ModItems.DNA_CONTAINER.get() && stack.m_41782_());
    }

    protected abstract List<Pair<Integer, Integer>> getSlotsPrioritized();

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack1 = slot.m_7993_();
            stack = stack1.m_41777_();
            int inventorySlots = 36;
            if (index > 35) {
                if (!this.m_38903_(stack1, 0, 34, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                Pair<Integer, Integer> prioritizedSlot;
                boolean moved = false;
                Iterator<Pair<Integer, Integer>> iterator = this.prioritizedSlots.iterator();
                while (iterator.hasNext() && !(moved = this.m_38903_(stack1, (prioritizedSlot = iterator.next()).getA() + 36, (prioritizedSlot.getB() == null ? prioritizedSlot.getA() : prioritizedSlot.getB()) + 36 + 1, false))) {
                }
                if (!moved) {
                    return ItemStack.f_41583_;
                }
            }
            if (stack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack1.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, stack1);
        }
        return stack;
    }

    public class LimitedItemInfoSlot
    extends SlotItemHandlerWithInfo {
        private Predicate<ItemStack> conditions;
        private Predicate<Player> canTake;
        private boolean limited;

        public LimitedItemInfoSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, String usage) {
            super(itemHandler, index, xPosition, yPosition, usage);
            this.conditions = stack -> true;
            this.canTake = stack -> true;
            this.limited = false;
        }

        public boolean m_5857_(ItemStack stack) {
            return this.conditions.test(stack);
        }

        public boolean m_8010_(Player playerIn) {
            return this.canTake.test(playerIn);
        }

        public int m_6641_() {
            return this.limited ? 1 : super.m_6641_();
        }

        public int m_5866_(ItemStack stack) {
            return this.limited ? 1 : super.m_5866_(stack);
        }

        public LimitedItemInfoSlot setLimited() {
            this.limited = true;
            return this;
        }

        public LimitedItemInfoSlot setConditions(boolean enabled) {
            return this.setConditions((ItemStack stack) -> enabled);
        }

        public LimitedItemInfoSlot setConditions(Item ... acceptableItems) {
            return this.setConditions((ItemStack stack) -> acceptableItems.length == 0 || Arrays.stream(acceptableItems).anyMatch(item -> stack.m_41720_() == item));
        }

        public LimitedItemInfoSlot setConditions(Predicate<ItemStack> conditions) {
            this.conditions = conditions;
            return this;
        }

        public LimitedItemInfoSlot setConditions(TierItem.ItemType type) {
            this.conditions = stack -> stack.m_41720_() instanceof TierItem && ((TierItem)stack.m_41720_()).getItemType() == type;
            return this;
        }

        public LimitedItemInfoSlot setCanTake(boolean enabled) {
            return this.setCanTake(stack -> enabled);
        }

        public LimitedItemInfoSlot setCanTake(Predicate<Player> conditions) {
            this.canTake = conditions;
            return this;
        }
    }

    public class SlotItemHandlerWithInfo
    extends SlotItemHandler {
        private final String usage;
        protected boolean listening;

        public SlotItemHandlerWithInfo(IItemHandler itemHandler, int index, int xPosition, int yPosition, String usage) {
            super(itemHandler, index, xPosition, yPosition);
            this.listening = false;
            this.usage = usage;
        }

        public String getUsageString() {
            return this.usage;
        }

        public void m_6654_() {
            BaseMenu baseMenu;
            super.m_6654_();
            if (this.listening) {
                BaseMenu.this.m_38946_();
                baseMenu = BaseMenu.this;
                if (baseMenu instanceof BlockBaseMenu) {
                    BlockBaseMenu blockMenu = (BlockBaseMenu)baseMenu;
                    blockMenu.blockEntity.onContainerUpdated(this.getSlotIndex());
                }
            }
            if ((baseMenu = BaseMenu.this) instanceof BlockBaseMenu) {
                BlockBaseMenu menu = (BlockBaseMenu)baseMenu;
                menu.blockEntity.m_6596_();
            }
        }

        public SlotItemHandlerWithInfo setShouldListen() {
            this.listening = true;
            return this;
        }

        public String toString() {
            return "SlotItemHandlerWithInfo{usage='" + this.usage + "', listening=" + this.listening + "}";
        }
    }
}

